package com.abloq.purix.utils

import android.content.Context
import com.abloq.purix.models.Category
import com.abloq.purix.models.Song
import com.google.gson.Gson
import com.google.gson.reflect.TypeToken
import java.io.InputStreamReader

object ManifestLoader {
    private val gson = Gson()

    fun loadMainManifest(context: Context): List<Category> {
        return try {
            val inputStream = context.assets.open("MainManifest.json")
            val reader = InputStreamReader(inputStream)
            val type = object : TypeToken<List<Category>>() {}.type
            gson.fromJson(reader, type)
        } catch (e: Exception) {
            e.printStackTrace()
            emptyList()
        }
    }

    fun loadCategoryManifest(context: Context, manifestPath: String): List<Song> {
        return try {
            val inputStream = context.assets.open(manifestPath)
            val reader = InputStreamReader(inputStream)
            val type = object : TypeToken<List<Song>>() {}.type
            gson.fromJson(reader, type)
        } catch (e: Exception) {
            e.printStackTrace()
            emptyList()
        }
    }
}
