import Dexie, { type Table } from 'dexie';

export interface Setting {
  id?: number;
  key: string;
  value: any;
}

export interface Order {
  id?: number;
  productName: string;
  orderDate: Date;
  estimatedArrival: Date;
  collectionCode: string;
  status: 'pending' | 'arrived' | 'collected';
  notes?: string;
}

export interface InventoryItem {
  id?: number;
  name: string;
  category: string;
  technicalInfo: string;
  version: string;
  hasWifi: boolean;
  quantity: number;
  location: string;
}

export interface Repair {
  id?: number;
  customerName: string;
  productName: string;
  intakeDate: Date;
  location: string;
  status: string; // Dynamic based on user settings
  progress: number; // 0-100
  estimatedCompletion?: Date;
}

export interface Sale {
  id?: number;
  productName: string;
  saleDate: Date;
  price: number;
  moneyLocation: string;
  notes?: string;
}

export class MyDatabase extends Dexie {
  settings!: Table<Setting>;
  orders!: Table<Order>;
  inventory!: Table<InventoryItem>;
  repairs!: Table<Repair>;
  sales!: Table<Sale>;

  constructor() {
    super('InventoryLogisticsDB');
    this.version(1).stores({
      settings: '++id, key',
      orders: '++id, productName, status',
      inventory: '++id, name, category',
      repairs: '++id, customerName, status',
      sales: '++id, saleDate'
    });
  }
}

export const db = new MyDatabase();
