// שימוש ב-Set כדי לשמור את הכפתורים שכבר לחצנו עליהם
// WeakSet מאפשר לדפדפן לנקות את הזיכרון כשהשיר נמחק מהצ'אט
const clickedButtons = new WeakSet();

function instantClick() {
    // מחפש את כל כפתורי ההורדה בדף (גם הישנים וגם החדשים)
    const allDownloadButtons = document.querySelectorAll('button[aria-label*="הורדת"], button.download-button');

    allDownloadButtons.forEach(btn => {
        // בודק 3 תנאים:
        // 1. שהכפתור לא "מושבת" (כלומר השיר מוכן)
        // 2. שעדיין לא לחצנו עליו בעבר (לא נמצא ב-Set שלנו)
        if (!btn.disabled && !btn.hasAttribute('disabled') && !clickedButtons.has(btn)) {
            
            // מסמן מיד את הכפתור כ"טופל" כדי שלא נלחץ עליו שוב
            clickedButtons.add(btn);
            
            console.log("⚡ נמצא שיר חדש ומוכן! מבצע הורדה מיידית...");

            // לחיצה ראשונה לפתיחת התפריט
            btn.click();

            // חיפוש אגרסיבי של כפתור ה-MP3 בתפריט
            let attempts = 0;
            const findMp3 = setInterval(() => {
                // מחפש אלמנטים בתפריט שצץ (בדרך כלל נוסף לסוף ה-BODY)
                const menuItems = document.querySelectorAll('.mat-mdc-menu-item, .mat-menu-item, button');
                
                for (let item of menuItems) {
                    // מחפש ספציפית את המילה MP3
                    if (item.textContent.toUpperCase().includes('MP3')) {
                        item.click();
                        console.log("✅ MP3 נלחץ בהצלחה לשיר החדש!");
                        clearInterval(findMp3);
                        return;
                    }
                }
                
                attempts++;
                // אם עבר זמן סביר (700 מילי-שנייה) והתפריט לא נמצא, מפסיקים
                if (attempts > 70) {
                    clearInterval(findMp3);
                }
            }, 10); // בדיקה כל 10 מילי-שניות למהירות מקסימלית
        }
    });
}

// מאזין לשינויים ב-DOM (הוספת הודעות חדשות או שינוי מצב כפתור מ-disabled לזמין)
const observer = new MutationObserver((mutations) => {
    instantClick();
});

// הגדרת האזנה רחבה מספיק כדי לתפוס שינויים בתוך ההודעות
observer.observe(document.body, {
    childList: true,
    subtree: true,
    attributes: true,
    attributeFilter: ['disabled']
});

console.log("🤖 Gemini Multi-Track Downloader פועל ומחכה לשירים...");