#!/system/bin/sh
MODDIR="${0%/*}"
LOGFILE="$MODDIR/blocker_log.txt"
echo "Starting blocker (Unified + Specific 'video/' XML strip)..." > "$LOGFILE"

stop media
stop media.codec
stop media.extractor
stop mediaserver
stop audioserver

MAX_WAIT=50
WAIT_COUNT=0
while [ ! -d "/apex/com.android.media" ]; do
    if [ $WAIT_COUNT -ge $MAX_WAIT ]; then break; fi
    sleep 0.1
    WAIT_COUNT=$((WAIT_COUNT+1))
done

mount --make-rshared /apex
mount --make-rshared /vendor 2>/dev/null
mount --make-rshared /system 2>/dev/null

REP_BASE="$MODDIR/local_mirror"
rm -rf "$REP_BASE"
mkdir -p "$REP_BASE"
chmod 755 "$REP_BASE"

APEX_DIRS=$(find /apex -maxdepth 1 -type d -name "com.android.media*" ! -name "*@*")
TARGET_DIRS="$APEX_DIRS /system/lib64 /system/lib /vendor/lib64 /vendor/lib"
KEYWORDS="mp4 mpeg avi mkv flv hevc avc h263 h264 h265 vp8 vp9 mov wmv 3gp divx xvid video ffmpeg webm av1 vpx ijk"

for DIR in $TARGET_DIRS; do
    if [ -d "$DIR" ]; then
        SEARCH_PATH="$DIR"
        if echo "$DIR" | grep -q "/apex/"; then
             SEARCH_PATH="$DIR/lib $DIR/lib64"
        fi

        for SUB_DIR in $SEARCH_PATH; do
            if [ -d "$SUB_DIR" ]; then
                for K in $KEYWORDS; do
                    
                    K_UPPER=$(echo "$K" | tr 'a-z' 'A-Z')
                    
                    for VARIATION in "$K" "$K_UPPER"; do
                        
                        find "$SUB_DIR" -type f -name "*$VARIATION*.so" | while read -r TARGET_FILE; do
                            
                            PDIR=$(dirname "$TARGET_FILE")
                            MP3_SRC=$(find "$PDIR" -maxdepth 1 -type f -name "*mp3*" | head -n 1)
                            
                            if [ ! -z "$MP3_SRC" ]; then
                                REL_PATH=$(echo "$TARGET_FILE" | sed 's|^/||')
                                LOCAL_DIR="$REP_BASE/$(dirname "$REL_PATH")"
                                mkdir -p "$LOCAL_DIR"
                                LOCAL_STUB="$REP_BASE/$REL_PATH"
                                
                                cp "$MP3_SRC" "$LOCAL_STUB"
                                
                                
                                if echo "$TARGET_FILE" | grep -q "/vendor/"; then
                                    chcon u:object_r:vendor_file:s0 "$LOCAL_STUB" 2>/dev/null
                                else
                                    chcon u:object_r:system_lib_file:s0 "$LOCAL_STUB" 2>/dev/null
                                fi
                                chmod 644 "$LOCAL_STUB"
                                
                                mount --bind "$LOCAL_STUB" "$TARGET_FILE"
                                echo "Blocked: $TARGET_FILE" >> "$LOGFILE"

                                if echo "$TARGET_FILE" | grep -q "^/apex/"; then
                                    APEX_NAME=$(echo "$TARGET_FILE" | cut -d/ -f3)
                                    VERSIONED_APEX_DIR=$(ls -d /apex/${APEX_NAME}@* 2>/dev/null | head -n 1)
                                    if [ ! -z "$VERSIONED_APEX_DIR" ]; then
                                        SUFFIX_PATH=$(echo "$TARGET_FILE" | sed "s|^/apex/${APEX_NAME}||")
                                        TARGET_VERSIONED="${VERSIONED_APEX_DIR}${SUFFIX_PATH}"
                                        if [ -f "$TARGET_VERSIONED" ]; then
                                            mount --bind "$LOCAL_STUB" "$TARGET_VERSIONED"
                                        fi
                                    fi
                                fi
                            fi
                        done
                    done
                done
            fi
        done
    fi
done


TARGET_XML="/vendor/etc/media_codecs_c2.xml"

if [ -f "$TARGET_XML" ]; then
    LOCAL_XML="$REP_BASE/media_codecs_c2.xml"
    
    
    cat "$TARGET_XML" | grep -v "video/" > "$LOCAL_XML"
    
    if [ -s "$LOCAL_XML" ]; then
        chmod 644 "$LOCAL_XML"
        
        chcon u:object_r:vendor_configs_file:s0 "$LOCAL_XML" 2>/dev/null
        
        mount --bind "$LOCAL_XML" "$TARGET_XML"
        echo "Fixed XML (video/ stripped): $TARGET_XML" >> "$LOGFILE"
    fi
fi


start media
start media.codec
start media.extractor
start mediaserver
start audioserver
