const green = document.getElementById("green");
const orange = document.getElementById("orange");
const opacity = document.getElementById("opacity");

chrome.storage.sync.get(["thresholds","opacity"]).then(s => {
  const t = s.thresholds || { green: 600, orange: 1800 };
  green.value = Math.floor(t.green / 60);
  orange.value = Math.floor(t.orange / 60);
  opacity.value = s.opacity ?? 1;
});

document.getElementById("save").onclick = () => {
  chrome.storage.sync.set({
    thresholds: {
      green: green.value * 60,
      orange: orange.value * 60
    },
    opacity: opacity.value
  });
};