const ui = document.createElement("div");
ui.id = "focus-ui";
ui.innerHTML = `
  <div id="drag">☰</div>
  <div id="headline">⚠️ שים לב שאתה לא מבזבז את הזמן</div>
  <div id="subtitle">סך הזמן שבזבזת באתר זה</div>
  <div id="timer">00:00:00</div>
  <button id="settings">⚙️ הגדרות</button>
`;
document.body.appendChild(ui);

// restore settings
let thresholds = { green: 600, orange: 1800 };
chrome.storage.sync.get(["pos","opacity","thresholds"]).then(s => {
  if (s.pos) {
    ui.style.left = s.pos.x + "px";
    ui.style.top = s.pos.y + "px";
    ui.style.transform = "none";
  }
  if (s.opacity !== undefined) ui.style.opacity = s.opacity;
  if (s.thresholds) thresholds = s.thresholds;
});

// drag
let dragging=false, ox=0, oy=0;
document.getElementById("drag").onmousedown = e => {
  dragging=true;
  ox = e.clientX - ui.offsetLeft;
  oy = e.clientY - ui.offsetTop;
};
document.onmousemove = e => {
  if (!dragging) return;
  ui.style.left = e.clientX - ox + "px";
  ui.style.top = e.clientY - oy + "px";
};
document.onmouseup = () => {
  if (dragging) {
    chrome.storage.sync.set({ pos: { x: ui.offsetLeft, y: ui.offsetTop }});
  }
  dragging=false;
};

// open options
document.getElementById("settings").onclick = () => {
  chrome.runtime.sendMessage({ type: "OPEN_OPTIONS" });
};

// timer + colors
let sec = 0;
setInterval(() => {
  sec++;
  document.getElementById("timer").textContent =
    new Date(sec * 1000).toISOString().substr(11, 8);

  if (sec < thresholds.green) ui.dataset.level = "green";
  else if (sec < thresholds.orange) ui.dataset.level = "orange";
  else ui.dataset.level = "red";
}, 1000);

// listen for opacity changes (live update)
chrome.storage.onChanged.addListener((changes, area) => {
  if (area === "sync" && changes.opacity) {
    ui.style.opacity = changes.opacity.newValue;
  }
});