/*
 * Decompiled with CFR 0.152.
 */
package brut.xmlpull;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashSet;
import org.xmlpull.v1.XmlSerializer;

public final class MXSerializer
implements XmlSerializer {
    public static final String[] precomputedPrefixes = new String[32];
    public boolean attrValueNoEscape;
    public String defaultEncoding;
    public String indentationString;
    public String lineSeparator;
    public String location;
    public Writer writer;
    public int autoDeclaredPrefixes;
    public int depth;
    public String[] elNamespace;
    public String[] elName;
    public String[] elPrefix;
    public int[] elNamespaceCount;
    public int namespaceEnd;
    public String[] namespacePrefix;
    public String[] namespaceUri;
    public boolean finished;
    public boolean setPrefixCalled;
    public boolean startTagIncomplete;
    public boolean doIndent;
    public boolean seenTag;
    public boolean seenBracket;
    public boolean seenBracketBracket;
    public final char[] buffer;
    public int bufidx;
    public int offsetNewLine;
    public int indentationJump;
    public char[] indentationBuf;
    public int maxIndentLevel;
    public boolean writeLineSeparator;
    public boolean writeIndentation;

    public final String getLocation() {
        return this.location != null ? " @" + this.location : "";
    }

    public final void flushBuffer() {
        int n = this.bufidx;
        if (n > 0) {
            MXSerializer mXSerializer = this;
            mXSerializer.writer.write(this.buffer, 0, n);
            mXSerializer.writer.flush();
            mXSerializer.bufidx = 0;
        }
    }

    public final void write(char c) {
        if (this.bufidx >= 8192) {
            this.flushBuffer();
        }
        int n = this.bufidx;
        this.bufidx = n + 1;
        this.buffer[n] = c;
    }

    public final void write(String string) {
        int n = 0;
        int n2 = string.length();
        while (n2 > 0) {
            int n3;
            int n4;
            if (this.bufidx == 8192) {
                this.flushBuffer();
            }
            if ((n4 = 8192 - (n3 = this.bufidx)) > n2) {
                n4 = n2;
            }
            string.getChars(n, n += n4, this.buffer, n3);
            n2 -= n4;
            this.bufidx += n4;
        }
    }

    public final void writeIndent() {
        int n = this.writeLineSeparator ? 0 : this.offsetNewLine;
        char[] cArray = this.indentationBuf;
        int n2 = (Math.min(this.depth, this.maxIndentLevel) - 1) * this.indentationJump + this.offsetNewLine;
        while (n2 > 0) {
            int n3;
            int n4;
            if (this.bufidx == 8192) {
                this.flushBuffer();
            }
            if ((n4 = 8192 - (n3 = this.bufidx)) > n2) {
                n4 = n2;
            }
            System.arraycopy(cArray, n, this.buffer, n3, n4);
            n += n4;
            n2 -= n4;
            this.bufidx += n4;
        }
    }

    public final String getPrefix(String string, boolean bl, boolean bl2) {
        if ((string = string.intern()) != null) {
            if (!string.isEmpty()) {
                for (int i = this.namespaceEnd - 1; i >= 0; --i) {
                    if (!string.equals(this.namespaceUri[i])) continue;
                    String string2 = this.namespacePrefix[i];
                    if (bl2 && string2.isEmpty()) continue;
                    return string2;
                }
                if (!bl) {
                    return null;
                }
                return this.generatePrefix(string);
            }
            throw new IllegalArgumentException("default namespace cannot have prefix" + this.getLocation());
        }
        throw new IllegalArgumentException("namespace must be not null" + this.getLocation());
    }

    public final void closeStartTag() {
        block4: {
            block6: {
                block7: {
                    block5: {
                        boolean bl;
                        if (this.finished) break block4;
                        if (this.seenBracket) {
                            MXSerializer mXSerializer = this;
                            mXSerializer.seenBracketBracket = false;
                            mXSerializer.seenBracket = false;
                        }
                        if (!(bl = this.startTagIncomplete) && !this.setPrefixCalled) break block5;
                        if (this.setPrefixCalled) break block6;
                        if (!bl) break block7;
                        MXSerializer mXSerializer = this;
                        mXSerializer.writeNamespaceDeclarations();
                        mXSerializer.write('>');
                        MXSerializer mXSerializer2 = this;
                        int n = mXSerializer2.depth;
                        mXSerializer.elNamespaceCount[n] = mXSerializer2.namespaceEnd;
                        mXSerializer.startTagIncomplete = false;
                    }
                    return;
                }
                throw new IllegalArgumentException("trying to close start tag that is not opened" + this.getLocation());
            }
            throw new IllegalArgumentException("startTag() must be called immediately after setPrefix()" + this.getLocation());
        }
        throw new IllegalArgumentException("trying to write past already finished output" + this.getLocation());
    }

    public final String generatePrefix(String string) {
        int n;
        this.autoDeclaredPrefixes = n = this.autoDeclaredPrefixes + 1;
        String[] stringArray = precomputedPrefixes;
        String string2 = n < 32 ? stringArray[n] : ("n" + this.autoDeclaredPrefixes).intern();
        int n2 = this.namespaceEnd;
        String[] stringArray2 = this.namespacePrefix;
        if (n2 >= this.namespacePrefix.length) {
            int n3 = n2 > 7 ? n2 * 2 : 8;
            int n4 = n3;
            String[] stringArray3 = new String[n4];
            String[] stringArray4 = new String[n4];
            if (stringArray2 != null) {
                System.arraycopy(stringArray2, 0, stringArray3, 0, n2);
                n2 = this.namespaceEnd;
                System.arraycopy(this.namespaceUri, 0, stringArray4, 0, n2);
            }
            MXSerializer mXSerializer = this;
            mXSerializer.namespacePrefix = stringArray3;
            mXSerializer.namespaceUri = stringArray4;
        }
        MXSerializer mXSerializer = this;
        String[] stringArray5 = mXSerializer.namespacePrefix;
        int n5 = mXSerializer.namespaceEnd;
        stringArray5[n5] = string2;
        this.namespaceUri[n5] = string;
        mXSerializer.namespaceEnd = n5 + 1;
        return string2;
    }

    public final void writeNamespaceDeclarations() {
        HashSet<String> hashSet;
        HashSet<String> hashSet2 = hashSet;
        hashSet = new HashSet<String>();
        for (int i = this.elNamespaceCount[this.depth - 1]; i < this.namespaceEnd; ++i) {
            MXSerializer mXSerializer = this;
            String string = mXSerializer.namespacePrefix[i];
            String string2 = mXSerializer.namespaceUri[i];
            if (hashSet2.contains(string + string2)) continue;
            if (this.doIndent && string2.length() > 40) {
                MXSerializer mXSerializer2 = this;
                mXSerializer2.writeIndent();
                mXSerializer2.write(' ');
            }
            this.write(" xmlns");
            if (string != "") {
                MXSerializer mXSerializer3 = this;
                mXSerializer3.write(':');
                mXSerializer3.write(string);
            }
            MXSerializer mXSerializer4 = this;
            this.write("=\"");
            mXSerializer4.writeAttributeValue(string2);
            mXSerializer4.write('\"');
            hashSet2.add(string + string2);
        }
    }

    public final void writeAttributeValue(String string) {
        if (((MXSerializer)((Object)stringBuilder2)).attrValueNoEscape) {
            ((MXSerializer)((Object)stringBuilder2)).write(string);
            return;
        }
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            int n2 = string.charAt(i);
            if (n2 == 38) {
                if (i > n) {
                    ((MXSerializer)((Object)stringBuilder2)).write(string.substring(n, i));
                }
                ((MXSerializer)((Object)stringBuilder2)).write("&amp;");
                n = i + 1;
            }
            if (n2 == 60) {
                if (i > n) {
                    ((MXSerializer)((Object)stringBuilder2)).write(string.substring(n, i));
                }
                ((MXSerializer)((Object)stringBuilder2)).write("&lt;");
                n = i + 1;
                continue;
            }
            if (n2 == 34) {
                if (i > n) {
                    ((MXSerializer)((Object)stringBuilder2)).write(string.substring(n, i));
                }
                ((MXSerializer)((Object)stringBuilder2)).write("&quot;");
                n = i + 1;
                continue;
            }
            if (n2 >= 32) continue;
            if (n2 != 13 && n2 != 10 && n2 != 9) {
                IllegalStateException illegalStateException;
                StringBuffer stringBuffer;
                StringBuilder stringBuilder = new StringBuilder("character ");
                StringBuffer stringBuffer2 = new StringBuffer();
                MXSerializer.addPrintable(stringBuffer2, (char)n2);
                StringBuilder stringBuilder2 = stringBuilder.append(stringBuffer2.toString()).append(" (").append(Integer.toString(n2)).append(") is not allowed in output").append(((MXSerializer)((Object)stringBuilder2)).getLocation()).append(" (attr value=");
                StringBuffer stringBuffer3 = stringBuffer;
                new StringBuffer(string.length() + 16).append("'");
                for (n2 = 0; n2 < string.length(); ++n2) {
                    MXSerializer.addPrintable(stringBuffer3, string.charAt(n2));
                }
                IllegalStateException illegalStateException2 = illegalStateException;
                StringBuffer stringBuffer4 = stringBuffer3;
                stringBuffer4.append("'");
                illegalStateException2(stringBuilder2.append(stringBuffer4.toString()).append(")").toString());
                throw illegalStateException2;
            }
            if (i > n) {
                ((MXSerializer)((Object)stringBuilder2)).write(string.substring(n, i));
            }
            MXSerializer mXSerializer = stringBuilder2;
            ((MXSerializer)((Object)stringBuilder2)).write("&#");
            mXSerializer.write(Integer.toString(n2));
            mXSerializer.write(';');
            n = i + 1;
        }
        if (n > 0) {
            string = string.substring(n);
        }
        ((MXSerializer)((Object)stringBuilder2)).write(string);
    }

    public final void endDocument() {
        int n;
        while ((n = this.depth) > 0) {
            MXSerializer mXSerializer = this;
            mXSerializer.endTag(mXSerializer.elNamespace[n], this.elName[n]);
        }
        if (this.writeLineSeparator) {
            MXSerializer mXSerializer = this;
            mXSerializer.write(mXSerializer.lineSeparator);
        }
        this.flushBuffer();
        this.startTagIncomplete = true;
        this.finished = true;
    }

    public final void setPrefix(String string, String string2) {
        if (this.startTagIncomplete) {
            this.closeStartTag();
        }
        if (string == null) {
            string = "";
        }
        string = string.intern();
        string2 = string2.intern();
        int n = this.namespaceEnd;
        String[] stringArray = this.namespacePrefix;
        if (n >= this.namespacePrefix.length) {
            int n2 = n > 7 ? n * 2 : 8;
            int n3 = n2;
            String[] stringArray2 = new String[n3];
            String[] stringArray3 = new String[n3];
            if (stringArray != null) {
                System.arraycopy(stringArray, 0, stringArray2, 0, n);
                n = this.namespaceEnd;
                System.arraycopy(this.namespaceUri, 0, stringArray3, 0, n);
            }
            MXSerializer mXSerializer = this;
            mXSerializer.namespacePrefix = stringArray2;
            mXSerializer.namespaceUri = stringArray3;
        }
        MXSerializer mXSerializer = this;
        String[] stringArray4 = mXSerializer.namespacePrefix;
        int n4 = mXSerializer.namespaceEnd;
        stringArray4[n4] = string;
        this.namespaceUri[n4] = string2;
        mXSerializer.namespaceEnd = n4 + 1;
        mXSerializer.setPrefixCalled = true;
    }

    public final void ignorableWhitespace(String string) {
        if (this.startTagIncomplete || this.setPrefixCalled || this.seenBracket) {
            this.closeStartTag();
        }
        if (this.doIndent && this.seenTag) {
            this.seenTag = false;
        }
        if (!string.isEmpty()) {
            this.write(string);
            return;
        }
        throw new IllegalArgumentException("empty string is not allowed for ignorable whitespace" + this.getLocation());
    }

    public final void setProperty(String string, String object) {
        int n = -1;
        switch (string.hashCode()) {
            default: {
                break;
            }
            case 1544270693: {
                if (!string.equals("http://xmlpull.org/v1/doc/properties.html#line-separator")) break;
                n = 3;
                break;
            }
            case 1540539790: {
                if (!string.equals("http://xmlpull.org/v1/doc/properties.html#location")) break;
                n = 2;
                break;
            }
            case -366201520: {
                if (!string.equals("http://xmlpull.org/v1/doc/properties.html#indentation")) break;
                n = 1;
                break;
            }
            case -1273393096: {
                if (!string.equals("http://xmlpull.org/v1/doc/properties.html#default-encoding")) break;
                n = 0;
            }
        }
        switch (n) {
            default: {
                throw new IllegalStateException("unsupported property: ".concat(string));
            }
            case 3: {
                this.lineSeparator = object;
                break;
            }
            case 2: {
                this.location = object;
                break;
            }
            case 1: {
                this.indentationString = object;
                break;
            }
            case 0: {
                this.defaultEncoding = object;
            }
        }
        string = this.lineSeparator;
        boolean bl = string != null && !string.isEmpty();
        this.writeLineSeparator = bl;
        String string2 = this.indentationString;
        int n2 = string2 != null && !string2.isEmpty() ? 1 : 0;
        this.writeIndentation = n2;
        n2 = this.indentationString != null && (this.writeLineSeparator || n2 != 0) ? 1 : 0;
        this.doIndent = n2;
        if (n2 != 0) {
            n2 = 0;
            this.offsetNewLine = 0;
            if (this.writeLineSeparator) {
                this.offsetNewLine = n2 = this.lineSeparator.length();
            }
            this.maxIndentLevel = 0;
            if (this.writeIndentation) {
                int n3;
                this.indentationJump = n3 = this.indentationString.length();
                this.maxIndentLevel = n = 65 / n3;
                n2 = n * n3 + n2;
            }
            object = this.indentationBuf;
            if (this.indentationBuf == null || ((Object)object).length < n2) {
                this.indentationBuf = new char[n2 + 8];
            }
            n2 = 0;
            if (this.writeLineSeparator) {
                for (int i = 0; i < this.lineSeparator.length(); ++i) {
                    this.indentationBuf[n2++] = this.lineSeparator.charAt(i);
                }
            }
            if (this.writeIndentation) {
                for (int i = 0; i < this.maxIndentLevel; ++i) {
                    for (n = 0; n < this.indentationString.length(); ++n) {
                        this.indentationBuf[n2++] = this.indentationString.charAt(n);
                    }
                }
            }
        }
        this.seenTag = false;
    }

    public final void setOutput(OutputStream outputStream) {
        if (outputStream != null) {
            OutputStreamWriter outputStreamWriter;
            Object object = this.defaultEncoding;
            if (object != null) {
                OutputStreamWriter outputStreamWriter2;
                outputStreamWriter = outputStreamWriter2;
                outputStreamWriter2 = new OutputStreamWriter(outputStream, (String)object);
            } else {
                OutputStreamWriter outputStreamWriter3;
                outputStreamWriter = outputStreamWriter3;
                outputStreamWriter3 = new OutputStreamWriter(outputStream);
            }
            MXSerializer mXSerializer = this;
            mXSerializer.writer = outputStreamWriter;
            mXSerializer.location = null;
            mXSerializer.autoDeclaredPrefixes = 0;
            mXSerializer.depth = 0;
            int n = 0;
            while (true) {
                object = this.elNamespaceCount;
                if (n >= this.elNamespaceCount.length) break;
                MXSerializer mXSerializer2 = this;
                mXSerializer2.elName[n] = null;
                mXSerializer2.elPrefix[n] = null;
                mXSerializer2.elNamespace[n] = null;
                object[n] = (String)2;
                ++n;
            }
            MXSerializer mXSerializer3 = this;
            mXSerializer3.namespaceEnd = 0;
            String[] stringArray = mXSerializer3.namespacePrefix;
            mXSerializer3.namespacePrefix[0] = "xmlns";
            object = mXSerializer3.namespaceUri;
            object[0] = "http://www.w3.org/2000/xmlns/";
            this.namespaceEnd = 1;
            stringArray[1] = "xml";
            mXSerializer3.namespaceUri[1] = "http://www.w3.org/XML/1998/namespace";
            mXSerializer3.namespaceEnd = 2;
            mXSerializer3.finished = false;
            mXSerializer3.setPrefixCalled = false;
            mXSerializer3.startTagIncomplete = false;
            mXSerializer3.seenTag = false;
            mXSerializer3.seenBracket = false;
            mXSerializer3.seenBracketBracket = false;
            return;
        }
        throw new IllegalArgumentException("output stream can not be null");
    }

    public final void startDocument() {
        MXSerializer mXSerializer = this;
        mXSerializer.write("<?xml version=\"1.0\"");
        String string = mXSerializer.defaultEncoding;
        if (string != null) {
            MXSerializer mXSerializer2 = this;
            mXSerializer2.write(" encoding=\"");
            mXSerializer2.write(string);
            mXSerializer2.write('\"');
        }
        MXSerializer mXSerializer3 = this;
        mXSerializer3.write("?>");
        if (mXSerializer3.writeLineSeparator) {
            MXSerializer mXSerializer4 = this;
            mXSerializer4.write(mXSerializer4.lineSeparator);
        }
    }

    public final MXSerializer startTag(String string, String string2) {
        Object object;
        int n;
        int n2;
        if (this.startTagIncomplete) {
            this.closeStartTag();
        }
        this.seenBracketBracket = false;
        this.seenBracket = false;
        this.depth = n2 = this.depth + 1;
        if (this.doIndent && n2 > 0 && this.seenTag) {
            this.writeIndent();
        }
        this.seenTag = true;
        this.setPrefixCalled = false;
        this.startTagIncomplete = true;
        n2 = this.depth;
        String[] stringArray = this.elName;
        if (n2 + 1 >= this.elName.length) {
            int n3 = stringArray.length;
            n2 = (n2 >= 7 ? n2 * 2 : 8) + 2;
            n = n3 > 0 ? 1 : 0;
            object = new String[n2];
            if (n != 0) {
                System.arraycopy(stringArray, 0, object, 0, n3);
            }
            this.elName = object;
            stringArray = new String[n2];
            if (n != 0) {
                System.arraycopy(this.elPrefix, 0, stringArray, 0, n3);
            }
            this.elPrefix = stringArray;
            stringArray = new String[n2];
            if (n != 0) {
                System.arraycopy(this.elNamespace, 0, stringArray, 0, n3);
            }
            this.elNamespace = stringArray;
            int[] nArray = new int[n2];
            if (n != 0) {
                System.arraycopy(this.elNamespaceCount, 0, nArray, 0, n3);
            } else {
                nArray[0] = 0;
            }
            this.elNamespaceCount = nArray;
        }
        Object object2 = this.elNamespace;
        int n4 = this.depth;
        String string3 = string == null ? string : string.intern();
        object2[n4] = string3;
        object2 = this.elName;
        n4 = this.depth;
        string3 = string2 == null ? string2 : string2.intern();
        object2[n4] = string3;
        if (this.writer != null) {
            this.write('<');
            if (string != null) {
                if (!string.isEmpty()) {
                    String string4;
                    int n5;
                    object2 = null;
                    n4 = this.depth;
                    if (n4 > 0 && (n5 = this.namespaceEnd) - this.elNamespaceCount[n4 - 1] == 1 && ((string4 = this.namespaceUri[n5 - 1]) == string || string4.equals(string))) {
                        String string5 = this.namespacePrefix[this.namespaceEnd - 1];
                        for (n = this.elNamespaceCount[this.depth - 1] - 1; n >= 2; --n) {
                            object = this.namespacePrefix[n];
                            if (object != string5 && !((String)object).equals(string5)) {
                                continue;
                            }
                            String string6 = this.namespaceUri[n];
                            if (string6 != string4 && !string6.equals(string4)) break;
                            --this.namespaceEnd;
                            object2 = string5;
                            break;
                        }
                    }
                    if (object2 == null) {
                        object2 = this.getPrefix(string, true, false);
                    }
                    if (!object2.isEmpty()) {
                        this.elPrefix[this.depth] = object2;
                        this.write((String)object2);
                        this.write(':');
                    } else {
                        this.elPrefix[this.depth] = "";
                    }
                } else {
                    for (int i = this.namespaceEnd - 1; i >= 0; --i) {
                        if (this.namespacePrefix[i] != "") continue;
                        String string7 = this.namespaceUri[i];
                        if (string7 == null) {
                            this.setPrefix("", "");
                            break;
                        }
                        if (string7.isEmpty()) break;
                        throw new IllegalStateException("start tag can not be written in empty default namespace as default namespace is currently bound to '" + string7 + "'" + this.getLocation());
                    }
                    this.elPrefix[this.depth] = "";
                }
            } else {
                this.elPrefix[this.depth] = "";
            }
            this.write(string2);
            return this;
        }
        throw new IllegalStateException("setOutput() must called set before serialization can start");
    }

    public final MXSerializer attribute(String string, String string2, String string3) {
        if (this.startTagIncomplete) {
            this.write(' ');
            if (string != null && !string.isEmpty()) {
                String string4 = this.getPrefix(string = string.intern(), false, true);
                if (string4 == null) {
                    string4 = this.generatePrefix(string);
                }
                MXSerializer mXSerializer = this;
                mXSerializer.write(string4);
                mXSerializer.write(':');
            }
            MXSerializer mXSerializer = this;
            mXSerializer.write(string2);
            mXSerializer.write("=\"");
            mXSerializer.writeAttributeValue(string3);
            mXSerializer.write('\"');
            return mXSerializer;
        }
        throw new IllegalArgumentException("startTag() must be called before attribute()" + this.getLocation());
    }

    public final MXSerializer endTag(String string, String string2) {
        this.seenBracketBracket = false;
        this.seenBracket = false;
        if (string != null) {
            string.intern();
        }
        if (string2 != null) {
            int n;
            if (this.startTagIncomplete) {
                this.writeNamespaceDeclarations();
                this.write(" />");
            } else {
                if (this.doIndent && this.seenTag) {
                    this.writeIndent();
                }
                this.write("</");
                string = this.elPrefix[this.depth];
                if (!string.isEmpty()) {
                    this.write(string);
                    this.write(':');
                }
                this.write(string2);
                this.write('>');
            }
            this.depth = n = this.depth - 1;
            this.namespaceEnd = this.elNamespaceCount[n];
            this.startTagIncomplete = false;
            this.seenTag = true;
            return this;
        }
        throw new IllegalArgumentException("end tag name can not be null" + this.getLocation());
    }

    public final MXSerializer text(String string) {
        if (((MXSerializer)((Object)stringBuilder)).startTagIncomplete || ((MXSerializer)((Object)stringBuilder)).setPrefixCalled) {
            ((MXSerializer)((Object)stringBuilder)).closeStartTag();
        }
        if (((MXSerializer)((Object)stringBuilder)).doIndent && ((MXSerializer)((Object)stringBuilder)).seenTag) {
            ((MXSerializer)((Object)stringBuilder)).seenTag = false;
        }
        if (string != null) {
            int n = 0;
            for (int i = 0; i < string.length(); ++i) {
                int n2 = string.charAt(i);
                if (n2 == 93) {
                    if (((MXSerializer)((Object)stringBuilder)).seenBracket) {
                        ((MXSerializer)((Object)stringBuilder)).seenBracketBracket = true;
                        continue;
                    }
                    ((MXSerializer)((Object)stringBuilder)).seenBracket = true;
                    continue;
                }
                if (n2 == 38) {
                    if (i >= string.length() - 3 || string.charAt(i + 1) != 'l' || string.charAt(i + 2) != 't' || string.charAt(i + 3) != ';') {
                        if (i > n) {
                            ((MXSerializer)((Object)stringBuilder)).write(string.substring(n, i));
                        }
                        ((MXSerializer)((Object)stringBuilder)).write("&amp;");
                        n = i + 1;
                    }
                } else if (n2 == 60) {
                    if (i > n) {
                        ((MXSerializer)((Object)stringBuilder)).write(string.substring(n, i));
                    }
                    ((MXSerializer)((Object)stringBuilder)).write("&lt;");
                    n = i + 1;
                } else if (((MXSerializer)((Object)stringBuilder)).seenBracketBracket && n2 == 62) {
                    if (i > n) {
                        ((MXSerializer)((Object)stringBuilder)).write(string.substring(n, i));
                    }
                    ((MXSerializer)((Object)stringBuilder)).write("&gt;");
                    n = i + 1;
                } else if (n2 < 32 && n2 != 9 && n2 != 10 && n2 != 13) {
                    IllegalStateException illegalStateException;
                    StringBuffer stringBuffer;
                    StringBuilder stringBuilder = new StringBuilder("character ").append(Integer.toString(n2)).append(" is not allowed in output").append(((MXSerializer)((Object)stringBuilder)).getLocation()).append(" (text value=");
                    StringBuffer stringBuffer2 = stringBuffer;
                    new StringBuffer(string.length() + 16).append("'");
                    for (n2 = 0; n2 < string.length(); ++n2) {
                        MXSerializer.addPrintable(stringBuffer2, string.charAt(n2));
                    }
                    IllegalStateException illegalStateException2 = illegalStateException;
                    StringBuffer stringBuffer3 = stringBuffer2;
                    stringBuffer3.append("'");
                    illegalStateException2(stringBuilder.append(stringBuffer3.toString()).append(")").toString());
                    throw illegalStateException2;
                }
                if (!((MXSerializer)((Object)stringBuilder)).seenBracket) continue;
                ((MXSerializer)((Object)stringBuilder)).seenBracket = false;
                ((MXSerializer)((Object)stringBuilder)).seenBracketBracket = false;
            }
            if (n > 0) {
                string = string.substring(n);
            }
            ((MXSerializer)((Object)stringBuilder)).write(string);
        }
        return stringBuilder;
    }

    public MXSerializer() {
        String[] stringArray = stringArray2;
        stringArray.depth = 0;
        String[] stringArray2 = new String[2];
        v1.elNamespace = stringArray2;
        stringArray.elName = new String[stringArray2.length];
        v1.elPrefix = new String[stringArray2.length];
        stringArray.elNamespaceCount = new int[stringArray2.length];
        v1.namespaceEnd = 0;
        stringArray2 = new String[8];
        stringArray.namespacePrefix = stringArray2;
        v1.namespaceUri = new String[stringArray2.length];
        stringArray.buffer = new char[8192];
    }

    public static void addPrintable(StringBuffer charSequence, char c) {
        switch (c) {
            default: {
                if (c >= ' ' && c <= '~') {
                    ((StringBuffer)charSequence).append(c);
                    break;
                }
                StringBuffer stringBuffer = charSequence;
                CharSequence charSequence2 = charSequence = "0000" + Integer.toString(c, 16);
                stringBuffer.append("\\u").append(((String)charSequence2).substring(((String)charSequence2).length() - 4));
                break;
            }
            case '\\': {
                ((StringBuffer)charSequence).append("\\\\");
                break;
            }
            case '\'': {
                ((StringBuffer)charSequence).append("\\'");
                break;
            }
            case '\"': {
                ((StringBuffer)charSequence).append("\\\"");
                break;
            }
            case '\r': {
                ((StringBuffer)charSequence).append("\\r");
                break;
            }
            case '\f': {
                ((StringBuffer)charSequence).append("\\f");
                break;
            }
            case '\n': {
                ((StringBuffer)charSequence).append("\\n");
                break;
            }
            case '\t': {
                ((StringBuffer)charSequence).append("\\t");
                break;
            }
            case '\b': {
                ((StringBuffer)charSequence).append("\\b");
            }
        }
    }

    static {
        int n = 0;
        while (true) {
            String[] stringArray = precomputedPrefixes;
            if (n >= precomputedPrefixes.length) break;
            stringArray[n] = ("n" + n).intern();
            ++n;
        }
    }
}

