/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.apk;

import brut.androlib.apk.YamlSerializable;
import brut.androlib.apk.YamlStringEscapeUtils;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class YamlWriter
implements Closeable {
    public final PrintWriter mWriter;
    public int mIndent;

    public YamlWriter(OutputStream outputStream) {
        OutputStreamWriter outputStreamWriter;
        BufferedWriter bufferedWriter;
        PrintWriter printWriter;
        Closeable closeable = printWriter;
        BufferedWriter bufferedWriter2 = bufferedWriter;
        OutputStreamWriter outputStreamWriter2 = outputStreamWriter;
        outputStreamWriter = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
        bufferedWriter = new BufferedWriter(outputStreamWriter2);
        printWriter = new PrintWriter(bufferedWriter2);
        v3.mWriter = closeable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String escape(String string) {
        int n;
        String string2;
        StringWriter stringWriter;
        StringWriter stringWriter2;
        if (string == null) {
            return null;
        }
        try {
            stringWriter = stringWriter2;
            string2 = string;
            n = string.length();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        stringWriter(n * 2);
        YamlStringEscapeUtils.escapeJavaStyleString(stringWriter2, string2);
        return stringWriter2.toString();
    }

    @Override
    public final void close() {
        this.mWriter.close();
    }

    public final void writeIndent() {
        this.mWriter.print(String.join((CharSequence)"", Collections.nCopies(this.mIndent, " ")));
    }

    public final void writeBool(String string, boolean bl) {
        this.writeIndent();
        String string2 = bl ? "true" : "false";
        this.mWriter.println(YamlWriter.escape(string) + ": " + string2);
    }

    public final void writeString(String string, String string2) {
        this.writeIndent();
        if (Objects.isNull(string2)) {
            this.mWriter.println(YamlWriter.escape(string) + ": null");
        } else {
            this.mWriter.println(YamlWriter.escape(string) + ": " + YamlWriter.escape(string2));
        }
    }

    public final void writeList(String object, List list) {
        if (Objects.isNull(list)) {
            return;
        }
        YamlWriter yamlWriter = this;
        yamlWriter.writeIndent();
        yamlWriter.mWriter.println(YamlWriter.escape((String)object) + ":");
        object = list.iterator();
        while (object.hasNext()) {
            YamlWriter yamlWriter2 = this;
            list = object.next();
            yamlWriter2.writeIndent();
            yamlWriter2.mWriter.println("- " + list);
        }
    }

    public final void writeMap(String object, Map map) {
        if (Objects.isNull(map)) {
            return;
        }
        YamlWriter yamlWriter = this;
        yamlWriter.writeIndent();
        yamlWriter.mWriter.println(YamlWriter.escape((String)object) + ":");
        yamlWriter.mIndent += 2;
        for (String string : map.keySet()) {
            this.writeString(string, String.valueOf(map.get(string)));
        }
        int n = this.mIndent;
        if (n != 0) {
            this.mIndent = n - 2;
        }
    }

    public final void writeObject(String string, YamlSerializable yamlSerializable) {
        if (Objects.isNull(yamlSerializable)) {
            return;
        }
        YamlWriter yamlWriter = this;
        yamlWriter.writeIndent();
        yamlWriter.mWriter.println(YamlWriter.escape(string) + ":");
        yamlWriter.mIndent += 2;
        yamlSerializable.write(yamlWriter);
        int n = this.mIndent;
        if (n != 0) {
            this.mIndent = n - 2;
        }
    }
}

