/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib;

import brut.androlib.Config;
import brut.androlib.apk.ApkInfo;
import brut.androlib.exceptions.AndrolibException;
import brut.common.BrutException;
import brut.directory.ExtFile;
import brut.util.AaptManager;
import brut.util.OS;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Logger;

public final class AaptInvoker {
    public static final Logger LOGGER = Logger.getLogger(AaptInvoker.class.getName());
    public final ApkInfo mApkInfo;
    public final Config mConfig;

    public AaptInvoker(ApkInfo apkInfo, Config config) {
        this.mApkInfo = apkInfo;
        this.mConfig = config;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void invoke(ExtFile serializable, File file, File object, File file2, File[] fileArray) {
        ArrayList arrayList;
        int n;
        int n2;
        Object object2 = this.mConfig;
        Object object3 = ((Config)object2).mAaptBinary;
        if (object3 != null) {
            object2 = ((File)object3).getPath();
            n2 = 1;
        } else {
            try {
                object2 = AaptManager.getAaptBinary(((Config)object2).mAaptVersion).getPath();
                n2 = 0;
            }
            catch (BrutException brutException) {
                object3 = this.mConfig.mAaptVersion != 2 ? "aapt" : "aapt2";
                n = 1;
                LOGGER.warning((String)object3 + ": " + brutException.getMessage() + " (defaulting to $PATH binary)");
                n2 = n;
                object2 = object3;
            }
        }
        if (this.mConfig.mAaptVersion != 2) {
            ArrayList<Object> arrayList2;
            ArrayList<Object> arrayList3 = arrayList2;
            arrayList2 = new ArrayList<Object>();
            arrayList3.add(object2);
            arrayList3.add("p");
            if (this.mConfig.mVerbose) {
                arrayList3.add("-v");
            }
            this.mConfig.getClass();
            if (this.mConfig.mDebugMode) {
                arrayList3.add("--debug-mode");
            }
            if (this.mConfig.mNoCrunch) {
                arrayList3.add("--no-crunch");
            }
            object2 = this.mApkInfo;
            if (((ApkInfo)object2).packageInfo.forcedPackageId != null && !((ApkInfo)object2).sharedLibrary && n2 == 0) {
                arrayList3.add("--forced-package-id");
                arrayList3.add(this.mApkInfo.packageInfo.forcedPackageId);
            }
            if (this.mApkInfo.sharedLibrary) {
                arrayList3.add("--shared-lib");
            }
            if ((String)this.mApkInfo.sdkInfo.get("minSdkVersion") != null) {
                arrayList3.add("--min-sdk-version");
                arrayList3.add((String)this.mApkInfo.sdkInfo.get("minSdkVersion"));
            }
            if ((String)this.mApkInfo.sdkInfo.get("targetSdkVersion") != null) {
                arrayList3.add("--target-sdk-version");
                object2 = this.mApkInfo;
                n2 = ApkInfo.mapSdkShorthandToVersion((String)((ApkInfo)object2).sdkInfo.get("targetSdkVersion"));
                int n3 = (String)((ApkInfo)object2).sdkInfo.get("minSdkVersion") != null ? ApkInfo.mapSdkShorthandToVersion((String)((ApkInfo)object2).sdkInfo.get("minSdkVersion")) : 0;
                int n4 = (String)((ApkInfo)object2).sdkInfo.get("maxSdkVersion") != null ? ApkInfo.mapSdkShorthandToVersion((String)((ApkInfo)object2).sdkInfo.get("maxSdkVersion")) : n2;
                arrayList3.add(Integer.toString(Math.max(n3, Math.min(n4, n2))));
            }
            if ((String)this.mApkInfo.sdkInfo.get("maxSdkVersion") != null) {
                arrayList3.add("--max-sdk-version");
                arrayList3.add((String)this.mApkInfo.sdkInfo.get("maxSdkVersion"));
                arrayList3.add("--max-res-version");
                arrayList3.add((String)this.mApkInfo.sdkInfo.get("maxSdkVersion"));
            }
            if (this.mApkInfo.packageInfo.renameManifestPackage != null) {
                arrayList3.add("--rename-manifest-package");
                arrayList3.add(this.mApkInfo.packageInfo.renameManifestPackage);
            }
            if (this.mApkInfo.versionInfo.versionCode != null) {
                arrayList3.add("--version-code");
                arrayList3.add(this.mApkInfo.versionInfo.versionCode);
            }
            if (this.mApkInfo.versionInfo.versionName != null) {
                arrayList3.add("--version-name");
                arrayList3.add(this.mApkInfo.versionInfo.versionName);
            }
            arrayList3.add("--no-version-vectors");
            arrayList3.add("-F");
            arrayList3.add(((File)serializable).getAbsolutePath());
            if (this.mApkInfo.isFrameworkApk) {
                arrayList3.add("-x");
            }
            if (fileArray != null) {
                for (File file3 : fileArray) {
                    arrayList3.add("-I");
                    arrayList3.add(file3.getPath());
                }
            }
            if (object != null) {
                arrayList3.add("-S");
                arrayList3.add(((File)object).getAbsolutePath());
            }
            arrayList3.add("-M");
            arrayList3.add(file.getAbsolutePath());
            if (file2 != null) {
                arrayList3.add(file2.getAbsolutePath());
            }
            try {
                OS.exec(arrayList3.toArray(new String[0]));
                Logger logger = LOGGER;
                logger.fine("command ran: ");
                logger.fine(((Object)arrayList3).toString());
                return;
            }
            catch (BrutException brutException) {
                throw new AndrolibException(brutException);
            }
        }
        File file4 = null;
        if (object != null && !(file4 = Paths.get(((File)object).getParent(), "build", "resources.zip").toFile()).exists()) {
            Logger logger;
            ArrayList<Object> arrayList4;
            ArrayList<Object> arrayList5;
            ArrayList<Object> arrayList6 = arrayList5 = arrayList4;
            ArrayList<Object> arrayList7 = arrayList5;
            arrayList5();
            arrayList7.add(object2);
            arrayList7.add("compile");
            arrayList7.add("--dir");
            arrayList6.add(((File)object).getAbsolutePath());
            arrayList6.add("--legacy");
            arrayList6.add("-o");
            arrayList4.add(file4.getAbsolutePath());
            if (this.mConfig.mVerbose) {
                arrayList5.add("-v");
            }
            if (this.mConfig.mNoCrunch) {
                arrayList5.add("--no-crunch");
            }
            try {
                OS.exec(arrayList5.toArray(new String[0]));
                logger = LOGGER;
            }
            catch (BrutException brutException) {
                throw new AndrolibException(brutException);
            }
            logger.fine("aapt2 compile command ran: ");
            logger.fine(((Object)arrayList5).toString());
        }
        Serializable serializable2 = serializable;
        serializable = arrayList;
        arrayList = new ArrayList();
        ((ArrayList)serializable).add(object2);
        ((ArrayList)serializable).add("link");
        ((ArrayList)serializable).add("-o");
        ((ArrayList)serializable).add(((File)serializable2).getAbsolutePath());
        object = this.mApkInfo.packageInfo.forcedPackageId;
        if (object != null && !((String)object).equals("1") && !this.mApkInfo.sharedLibrary) {
            ((ArrayList)serializable).add("--allow-reserved-package-id");
            ((ArrayList)serializable).add("--package-id");
            ((ArrayList)serializable).add(this.mApkInfo.packageInfo.forcedPackageId);
        }
        if (this.mApkInfo.sharedLibrary) {
            ((ArrayList)serializable).add("--shared-lib");
        }
        if ((String)this.mApkInfo.sdkInfo.get("minSdkVersion") != null) {
            ((ArrayList)serializable).add("--min-sdk-version");
            ((ArrayList)serializable).add((String)this.mApkInfo.sdkInfo.get("minSdkVersion"));
        }
        if ((String)this.mApkInfo.sdkInfo.get("targetSdkVersion") != null) {
            ((ArrayList)serializable).add("--target-sdk-version");
            object = this.mApkInfo;
            int n5 = ApkInfo.mapSdkShorthandToVersion((String)((ApkInfo)object).sdkInfo.get("targetSdkVersion"));
            n = (String)((ApkInfo)object).sdkInfo.get("minSdkVersion") != null ? ApkInfo.mapSdkShorthandToVersion((String)((ApkInfo)object).sdkInfo.get("minSdkVersion")) : 0;
            int n6 = (String)((ApkInfo)object).sdkInfo.get("maxSdkVersion") != null ? ApkInfo.mapSdkShorthandToVersion((String)((ApkInfo)object).sdkInfo.get("maxSdkVersion")) : n5;
            ((ArrayList)serializable).add(Integer.toString(Math.max(n, Math.min(n6, n5))));
        }
        if (this.mApkInfo.packageInfo.renameManifestPackage != null) {
            ((ArrayList)serializable).add("--rename-manifest-package");
            ((ArrayList)serializable).add(this.mApkInfo.packageInfo.renameManifestPackage);
            ((ArrayList)serializable).add("--rename-instrumentation-target-package");
            ((ArrayList)serializable).add(this.mApkInfo.packageInfo.renameManifestPackage);
        }
        if (this.mApkInfo.versionInfo.versionCode != null) {
            ((ArrayList)serializable).add("--version-code");
            ((ArrayList)serializable).add(this.mApkInfo.versionInfo.versionCode);
        }
        if (this.mApkInfo.versionInfo.versionName != null) {
            ((ArrayList)serializable).add("--version-name");
            ((ArrayList)serializable).add(this.mApkInfo.versionInfo.versionName);
        }
        ((ArrayList)serializable).add("--no-auto-version");
        ((ArrayList)serializable).add("--no-version-vectors");
        ((ArrayList)serializable).add("--no-version-transitions");
        ((ArrayList)serializable).add("--no-resource-deduping");
        ((ArrayList)serializable).add("--no-compile-sdk-metadata");
        ((ArrayList)serializable).add("--warn-manifest-validation");
        if (this.mApkInfo.sparseResources) {
            ((ArrayList)serializable).add("--enable-sparse-encoding");
        }
        if (this.mApkInfo.compactEntries) {
            ((ArrayList)serializable).add("--enable-compact-entries");
        }
        if (this.mApkInfo.isFrameworkApk) {
            ((ArrayList)serializable).add("-x");
        }
        if (!this.mApkInfo.featureFlags.isEmpty()) {
            ArrayList<String> arrayList8;
            ArrayList<String> arrayList9 = arrayList8;
            arrayList8 = new ArrayList<String>();
            for (Map.Entry entry : this.mApkInfo.featureFlags.entrySet()) {
                arrayList9.add((String)entry.getKey() + "=" + entry.getValue());
            }
            ((ArrayList)serializable).add("--feature-flags");
            ((ArrayList)serializable).add(String.join((CharSequence)",", arrayList9));
        }
        if (fileArray != null) {
            for (File file5 : fileArray) {
                ((ArrayList)serializable).add("-I");
                ((ArrayList)serializable).add(file5.getPath());
            }
        }
        ((ArrayList)serializable).add("--manifest");
        ((ArrayList)serializable).add(file.getAbsolutePath());
        if (file2 != null) {
            ((ArrayList)serializable).add("-R");
            ((ArrayList)serializable).add(file2.getAbsolutePath());
        }
        if (this.mConfig.mVerbose) {
            ((ArrayList)serializable).add("-v");
        }
        if (file4 != null) {
            ((ArrayList)serializable).add(file4.getAbsolutePath());
        }
        try {
            OS.exec(((ArrayList)serializable).toArray(new String[0]));
            Logger logger = LOGGER;
            logger.fine("aapt2 link command ran: ");
            logger.fine(serializable.toString());
            return;
        }
        catch (BrutException brutException) {
            throw new AndrolibException(brutException);
        }
    }
}

