/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig;

import com.android.apksig.ApkVerificationIssue;
import com.android.apksig.apk.ApkFormatException;
import com.android.apksig.apk.ApkUtilsLite;
import com.android.apksig.internal.apk.ApkSigResult;
import com.android.apksig.internal.apk.ApkSignerInfo;
import com.android.apksig.internal.apk.ApkSigningBlockUtilsLite;
import com.android.apksig.internal.apk.ContentDigestAlgorithm;
import com.android.apksig.internal.apk.SignatureAlgorithm;
import com.android.apksig.internal.apk.SignatureInfo;
import com.android.apksig.internal.apk.SignatureNotFoundException;
import com.android.apksig.internal.apk.stamp.V2SourceStampVerifier;
import com.android.apksig.internal.util.GuaranteedEncodedFormX509Certificate;
import com.android.apksig.internal.zip.CentralDirectoryRecord;
import com.android.apksig.internal.zip.LocalFileRecord;
import com.android.apksig.internal.zip.ZipUtils;
import com.android.apksig.util.DataSource;
import com.android.apksig.util.DataSources;
import com.android.apksig.zip.ZipFormatException;
import com.android.apksig.zip.ZipSections;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SourceStampVerifier {
    private final File mApkFile;
    private final DataSource mApkDataSource;
    private final int mMinSdkVersion;
    private final int mMaxSdkVersion;

    private SourceStampVerifier(File apkFile, DataSource apkDataSource, int minSdkVersion, int maxSdkVersion) {
        this.mApkFile = apkFile;
        this.mApkDataSource = apkDataSource;
        this.mMinSdkVersion = minSdkVersion;
        this.mMaxSdkVersion = maxSdkVersion;
    }

    public Result verifySourceStamp() {
        return this.verifySourceStamp(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result verifySourceStamp(String expectedCertDigest) {
        Object in = null;
        try {
            Object f;
            DataSource apk;
            if (this.mApkDataSource != null) {
                apk = this.mApkDataSource;
            } else if (this.mApkFile != null) {
                in = f = new RandomAccessFile(this.mApkFile, "r");
                apk = DataSources.asDataSource((RandomAccessFile)f, 0L, ((RandomAccessFile)f).length());
            } else {
                throw new IllegalStateException("APK not provided");
            }
            f = this.verifySourceStamp(apk, expectedCertDigest);
            return f;
        }
        catch (IOException e) {
            Result result = new Result();
            result.addVerificationError(29, e);
            Result result2 = result;
            return result2;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private Result verifySourceStamp(DataSource apk, String expectedCertDigest) {
        Result result = new Result();
        try {
            EnumMap<ContentDigestAlgorithm, Object> apkContentDigests;
            SignatureInfo signatureInfo;
            String actualCertDigest;
            ZipSections zipSections = ApkUtilsLite.findZipSections(apk);
            List<CentralDirectoryRecord> cdRecords = ZipUtils.parseZipCentralDirectory(apk, zipSections);
            CentralDirectoryRecord sourceStampCdRecord = null;
            for (CentralDirectoryRecord cdRecord : cdRecords) {
                if (!"stamp-cert-sha256".equals(cdRecord.getName())) continue;
                sourceStampCdRecord = cdRecord;
                break;
            }
            if (sourceStampCdRecord == null) {
                boolean stampSigningBlockFound;
                try {
                    ApkSigningBlockUtilsLite.findSignature(apk, zipSections, 1845461005);
                    stampSigningBlockFound = true;
                }
                catch (SignatureNotFoundException e) {
                    stampSigningBlockFound = false;
                }
                result.addVerificationError(stampSigningBlockFound ? 24 : 25, new Object[0]);
                return result;
            }
            byte[] sourceStampCertificateDigest = LocalFileRecord.getUncompressedData(apk, sourceStampCdRecord, zipSections.getZipCentralDirectoryOffset());
            if (expectedCertDigest != null && !expectedCertDigest.equalsIgnoreCase(actualCertDigest = ApkSigningBlockUtilsLite.toHex(sourceStampCertificateDigest))) {
                result.addVerificationError(23, actualCertDigest, expectedCertDigest);
                return result;
            }
            HashMap<Integer, Map<ContentDigestAlgorithm, byte[]>> signatureSchemeApkContentDigests = new HashMap<Integer, Map<ContentDigestAlgorithm, byte[]>>();
            if (this.mMaxSdkVersion >= 28) {
                try {
                    signatureInfo = ApkSigningBlockUtilsLite.findSignature(apk, zipSections, -262969152);
                }
                catch (SignatureNotFoundException e) {
                    signatureInfo = null;
                }
                if (signatureInfo != null) {
                    apkContentDigests = new EnumMap<ContentDigestAlgorithm, byte[]>(ContentDigestAlgorithm.class);
                    SourceStampVerifier.parseSigners(signatureInfo.signatureBlock, 3, apkContentDigests, result);
                    signatureSchemeApkContentDigests.put(3, apkContentDigests);
                }
            }
            if (this.mMaxSdkVersion >= 24 && (this.mMinSdkVersion < 28 || signatureSchemeApkContentDigests.isEmpty())) {
                try {
                    signatureInfo = ApkSigningBlockUtilsLite.findSignature(apk, zipSections, 1896449818);
                }
                catch (SignatureNotFoundException e) {
                    signatureInfo = null;
                }
                if (signatureInfo != null) {
                    apkContentDigests = new EnumMap(ContentDigestAlgorithm.class);
                    SourceStampVerifier.parseSigners(signatureInfo.signatureBlock, 2, apkContentDigests, result);
                    signatureSchemeApkContentDigests.put(2, apkContentDigests);
                }
            }
            if (this.mMinSdkVersion < 24 || signatureSchemeApkContentDigests.isEmpty()) {
                Map<ContentDigestAlgorithm, byte[]> apkContentDigests2 = SourceStampVerifier.getApkContentDigestFromV1SigningScheme(cdRecords, apk, zipSections, result);
                signatureSchemeApkContentDigests.put(1, apkContentDigests2);
            }
            ApkSigResult sourceStampResult = V2SourceStampVerifier.verify(apk, zipSections, sourceStampCertificateDigest, signatureSchemeApkContentDigests, this.mMinSdkVersion, this.mMaxSdkVersion);
            result.mergeFrom(sourceStampResult);
            return result;
        }
        catch (ApkFormatException | ZipFormatException | IOException e) {
            result.addVerificationError(28, e);
        }
        catch (NoSuchAlgorithmException e) {
            result.addVerificationError(29, e);
        }
        catch (SignatureNotFoundException e) {
            result.addVerificationError(30, new Object[0]);
        }
        return result;
    }

    public static void parseSigners(ByteBuffer apkSignatureSchemeBlock, int apkSigSchemeVersion, Map<ContentDigestAlgorithm, byte[]> apkContentDigests, Result result) {
        CertificateFactory certFactory;
        ByteBuffer signers;
        boolean isV2Block = apkSigSchemeVersion == 2;
        try {
            signers = ApkSigningBlockUtilsLite.getLengthPrefixedSlice(apkSignatureSchemeBlock);
        }
        catch (ApkFormatException e) {
            result.addVerificationWarning(isV2Block ? 1 : 9, new Object[0]);
            return;
        }
        if (!signers.hasRemaining()) {
            result.addVerificationWarning(isV2Block ? 2 : 10, new Object[0]);
            return;
        }
        try {
            certFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new RuntimeException("Failed to obtain X.509 CertificateFactory", e);
        }
        while (signers.hasRemaining()) {
            Result.SignerInfo signerInfo = new Result.SignerInfo();
            if (isV2Block) {
                result.addV2Signer(signerInfo);
            } else {
                result.addV3Signer(signerInfo);
            }
            try {
                ByteBuffer signer = ApkSigningBlockUtilsLite.getLengthPrefixedSlice(signers);
                SourceStampVerifier.parseSigner(signer, apkSigSchemeVersion, certFactory, apkContentDigests, signerInfo);
            }
            catch (ApkFormatException | BufferUnderflowException e) {
                signerInfo.addVerificationWarning(isV2Block ? 3 : 11, new Object[0]);
                return;
            }
        }
    }

    private static void parseSigner(ByteBuffer signerBlock, int apkSigSchemeVersion, CertificateFactory certFactory, Map<ContentDigestAlgorithm, byte[]> apkContentDigests, Result.SignerInfo signerInfo) throws ApkFormatException {
        boolean isV2Signer = apkSigSchemeVersion == 2;
        ByteBuffer signedData = ApkSigningBlockUtilsLite.getLengthPrefixedSlice(signerBlock);
        ByteBuffer digests = ApkSigningBlockUtilsLite.getLengthPrefixedSlice(signedData);
        ByteBuffer certificates = ApkSigningBlockUtilsLite.getLengthPrefixedSlice(signedData);
        while (digests.hasRemaining()) {
            try {
                ByteBuffer digest = ApkSigningBlockUtilsLite.getLengthPrefixedSlice(digests);
                int sigAlgorithmId = digest.getInt();
                byte[] digestBytes = ApkSigningBlockUtilsLite.readLengthPrefixedByteArray(digest);
                SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.findById(sigAlgorithmId);
                if (signatureAlgorithm == null) continue;
                apkContentDigests.put(signatureAlgorithm.getContentDigestAlgorithm(), digestBytes);
            }
            catch (ApkFormatException | BufferUnderflowException e) {
                signerInfo.addVerificationWarning(isV2Signer ? 8 : 16, new Object[0]);
                return;
            }
        }
        if (certificates.hasRemaining()) {
            X509Certificate certificate;
            byte[] encodedCert = ApkSigningBlockUtilsLite.readLengthPrefixedByteArray(certificates);
            try {
                certificate = (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(encodedCert));
            }
            catch (CertificateException e) {
                signerInfo.addVerificationWarning(isV2Signer ? 6 : 14, new Object[0]);
                return;
            }
            certificate = new GuaranteedEncodedFormX509Certificate(certificate, encodedCert);
            signerInfo.setSigningCertificate(certificate);
        }
        if (signerInfo.getSigningCertificate() == null) {
            signerInfo.addVerificationWarning(isV2Signer ? 7 : 15, new Object[0]);
            return;
        }
    }

    private static Map<ContentDigestAlgorithm, byte[]> getApkContentDigestFromV1SigningScheme(List<CentralDirectoryRecord> cdRecords, DataSource apk, ZipSections zipSections, Result result) throws IOException, ApkFormatException {
        CentralDirectoryRecord manifestCdRecord = null;
        ArrayList<CentralDirectoryRecord> signatureBlockRecords = new ArrayList<CentralDirectoryRecord>(1);
        EnumMap<ContentDigestAlgorithm, byte[]> v1ContentDigest = new EnumMap<ContentDigestAlgorithm, byte[]>(ContentDigestAlgorithm.class);
        for (CentralDirectoryRecord cdRecord : cdRecords) {
            String cdRecordName = cdRecord.getName();
            if (cdRecordName == null) continue;
            if (manifestCdRecord == null && "META-INF/MANIFEST.MF".equals(cdRecordName)) {
                manifestCdRecord = cdRecord;
                continue;
            }
            if (!cdRecordName.startsWith("META-INF/") || !cdRecordName.endsWith(".RSA") && !cdRecordName.endsWith(".DSA") && !cdRecordName.endsWith(".EC")) continue;
            signatureBlockRecords.add(cdRecord);
        }
        if (manifestCdRecord == null) {
            return v1ContentDigest;
        }
        if (signatureBlockRecords.isEmpty()) {
            result.addVerificationWarning(36, new Object[0]);
        } else {
            block6: for (CentralDirectoryRecord signatureBlockRecord : signatureBlockRecords) {
                try {
                    CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
                    byte[] signatureBlockBytes = LocalFileRecord.getUncompressedData(apk, signatureBlockRecord, zipSections.getZipCentralDirectoryOffset());
                    for (Certificate certificate : certFactory.generateCertificates(new ByteArrayInputStream(signatureBlockBytes))) {
                        if (!(certificate instanceof X509Certificate)) continue;
                        Result.SignerInfo signerInfo = new Result.SignerInfo();
                        signerInfo.setSigningCertificate((X509Certificate)certificate);
                        result.addV1Signer(signerInfo);
                        continue block6;
                    }
                }
                catch (CertificateException e) {
                    result.addVerificationWarning(37, signatureBlockRecord.getName(), e);
                    break;
                }
                catch (ZipFormatException e) {
                    throw new ApkFormatException("Failed to read APK", e);
                }
            }
        }
        try {
            byte[] manifestBytes = LocalFileRecord.getUncompressedData(apk, manifestCdRecord, zipSections.getZipCentralDirectoryOffset());
            v1ContentDigest.put(ContentDigestAlgorithm.SHA256, ApkUtilsLite.computeSha256DigestBytes(manifestBytes));
            return v1ContentDigest;
        }
        catch (ZipFormatException e) {
            throw new ApkFormatException("Failed to read APK", e);
        }
    }

    public static class Builder {
        private final File mApkFile;
        private final DataSource mApkDataSource;
        private int mMinSdkVersion = 1;
        private int mMaxSdkVersion = Integer.MAX_VALUE;

        public Builder(File apk) {
            if (apk == null) {
                throw new NullPointerException("apk == null");
            }
            this.mApkFile = apk;
            this.mApkDataSource = null;
        }

        public Builder(DataSource apk) {
            if (apk == null) {
                throw new NullPointerException("apk == null");
            }
            this.mApkDataSource = apk;
            this.mApkFile = null;
        }

        public Builder setMinCheckedPlatformVersion(int minSdkVersion) {
            this.mMinSdkVersion = minSdkVersion;
            return this;
        }

        public Builder setMaxCheckedPlatformVersion(int maxSdkVersion) {
            this.mMaxSdkVersion = maxSdkVersion;
            return this;
        }

        public SourceStampVerifier build() {
            return new SourceStampVerifier(this.mApkFile, this.mApkDataSource, this.mMinSdkVersion, this.mMaxSdkVersion);
        }
    }

    public static class Result {
        private final List<SignerInfo> mV1SchemeSigners = new ArrayList<SignerInfo>();
        private final List<SignerInfo> mV2SchemeSigners = new ArrayList<SignerInfo>();
        private final List<SignerInfo> mV3SchemeSigners = new ArrayList<SignerInfo>();
        private final List<List<SignerInfo>> mAllSchemeSigners = Arrays.asList(this.mV1SchemeSigners, this.mV2SchemeSigners, this.mV3SchemeSigners);
        private SourceStampInfo mSourceStampInfo;
        private final List<ApkVerificationIssue> mErrors = new ArrayList<ApkVerificationIssue>();
        private final List<ApkVerificationIssue> mWarnings = new ArrayList<ApkVerificationIssue>();
        private boolean mVerified;

        void addVerificationError(int errorId, Object ... params) {
            this.mErrors.add(new ApkVerificationIssue(errorId, params));
        }

        void addVerificationWarning(int warningId, Object ... params) {
            this.mWarnings.add(new ApkVerificationIssue(warningId, params));
        }

        private void addV1Signer(SignerInfo signerInfo) {
            this.mV1SchemeSigners.add(signerInfo);
        }

        private void addV2Signer(SignerInfo signerInfo) {
            this.mV2SchemeSigners.add(signerInfo);
        }

        private void addV3Signer(SignerInfo signerInfo) {
            this.mV3SchemeSigners.add(signerInfo);
        }

        public boolean isVerified() {
            return this.mVerified;
        }

        private void mergeFrom(ApkSigResult source) {
            switch (source.signatureSchemeVersion) {
                case 0: {
                    this.mVerified = source.verified;
                    if (source.mSigners.isEmpty()) break;
                    this.mSourceStampInfo = new SourceStampInfo(source.mSigners.get(0));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown ApkSigResult Signing Block Scheme Id " + source.signatureSchemeVersion);
                }
            }
        }

        public List<SignerInfo> getV1SchemeSigners() {
            return this.mV1SchemeSigners;
        }

        public List<SignerInfo> getV2SchemeSigners() {
            return this.mV2SchemeSigners;
        }

        public List<SignerInfo> getV3SchemeSigners() {
            return this.mV3SchemeSigners;
        }

        public SourceStampInfo getSourceStampInfo() {
            return this.mSourceStampInfo;
        }

        public boolean containsErrors() {
            if (!this.mErrors.isEmpty()) {
                return true;
            }
            for (List<SignerInfo> signers : this.mAllSchemeSigners) {
                for (SignerInfo signer : signers) {
                    if (!signer.containsErrors()) continue;
                    return true;
                }
            }
            return this.mSourceStampInfo != null && this.mSourceStampInfo.containsErrors();
        }

        public List<ApkVerificationIssue> getErrors() {
            return this.mErrors;
        }

        public List<ApkVerificationIssue> getWarnings() {
            return this.mWarnings;
        }

        public List<ApkVerificationIssue> getAllErrors() {
            ArrayList<ApkVerificationIssue> errors = new ArrayList<ApkVerificationIssue>();
            errors.addAll(this.mErrors);
            for (List<SignerInfo> signers : this.mAllSchemeSigners) {
                for (SignerInfo signer : signers) {
                    errors.addAll(signer.getErrors());
                }
            }
            if (this.mSourceStampInfo != null) {
                errors.addAll(this.mSourceStampInfo.getErrors());
            }
            return errors;
        }

        public List<ApkVerificationIssue> getAllWarnings() {
            ArrayList<ApkVerificationIssue> warnings = new ArrayList<ApkVerificationIssue>();
            warnings.addAll(this.mWarnings);
            for (List<SignerInfo> signers : this.mAllSchemeSigners) {
                for (SignerInfo signer : signers) {
                    warnings.addAll(signer.getWarnings());
                }
            }
            if (this.mSourceStampInfo != null) {
                warnings.addAll(this.mSourceStampInfo.getWarnings());
            }
            return warnings;
        }

        public static class SourceStampInfo {
            private final List<X509Certificate> mCertificates;
            private final List<X509Certificate> mCertificateLineage;
            private final List<ApkVerificationIssue> mErrors = new ArrayList<ApkVerificationIssue>();
            private final List<ApkVerificationIssue> mWarnings = new ArrayList<ApkVerificationIssue>();
            private final long mTimestamp;
            private static final boolean mWarningsAsErrors = true;

            private SourceStampInfo(ApkSignerInfo result) {
                this.mCertificates = result.certs;
                this.mCertificateLineage = result.certificateLineage;
                this.mErrors.addAll(result.getErrors());
                this.mWarnings.addAll(result.getWarnings());
                this.mTimestamp = result.timestamp;
            }

            public X509Certificate getCertificate() {
                return this.mCertificates.isEmpty() ? null : this.mCertificates.get(0);
            }

            public List<X509Certificate> getCertificatesInLineage() {
                return this.mCertificateLineage;
            }

            public boolean containsErrors() {
                return !this.mErrors.isEmpty() || !this.mWarnings.isEmpty();
            }

            public List<ApkVerificationIssue> getErrors() {
                ArrayList<ApkVerificationIssue> result = new ArrayList<ApkVerificationIssue>();
                result.addAll(this.mErrors);
                result.addAll(this.mWarnings);
                return result;
            }

            public List<ApkVerificationIssue> getWarnings() {
                return this.mWarnings;
            }

            public long getTimestampEpochSeconds() {
                return this.mTimestamp;
            }
        }

        public static class SignerInfo {
            private X509Certificate mSigningCertificate;
            private final List<ApkVerificationIssue> mErrors = new ArrayList<ApkVerificationIssue>();
            private final List<ApkVerificationIssue> mWarnings = new ArrayList<ApkVerificationIssue>();

            void setSigningCertificate(X509Certificate signingCertificate) {
                this.mSigningCertificate = signingCertificate;
            }

            void addVerificationError(int errorId, Object ... params) {
                this.mErrors.add(new ApkVerificationIssue(errorId, params));
            }

            void addVerificationWarning(int warningId, Object ... params) {
                this.mWarnings.add(new ApkVerificationIssue(warningId, params));
            }

            public X509Certificate getSigningCertificate() {
                return this.mSigningCertificate;
            }

            public List<ApkVerificationIssue> getErrors() {
                return this.mErrors;
            }

            public List<ApkVerificationIssue> getWarnings() {
                return this.mWarnings;
            }

            public boolean containsErrors() {
                return !this.mErrors.isEmpty();
            }
        }
    }
}

