/////////////////////////////////////////////////////////////////////////////
// ErrorToString.h : Error code definition file for Error to string translation
//

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#ifndef __AFXWIN_H__
	#error include 'stdafx.h' before including this file for PCH
#endif

CString ErrorToString(int status);

typedef enum
{
    E_SIMLOCK_SUCCEED   = 0,

    // Client error code [1+~4999)
	ERR_SIMLOCK_CONNECT_PHONE  =  100, //connect phone failed 

	ERR_SIMLOCK_WRONG_IMEI,   //wrong IMSI

	ERR_SIMLOCK_SEND_HUK,  //send HUK failed  

	ERR_SIMLOCK_SEND_PUK, //send RSA PK + HUK to AP failed

	ERR_SIMLOCK_AUTH_REQ,    //send authentication request failed

	ERR_SIMLOCK_SEND_DATA,   //send simlock/imei data to AP failed

	ERR_SIMLOCK_NOT_CONNECT_SERVER,             /* Failed to connect server. */

    // Rpc error code [5000~9999)
	ERR_SIMLOCK_EXEC_RPC_TIMEOUT = 5000,		/* Execute rpc timeout. */

	// SIMLOCK error code [10000,11000)
	ERR_SIMLOCK_KEY_ERROR	= 10000,			/* Invalid simlock key. */
	ERR_SIMLOCK_NOT_SET_PRODUCTNAME	= 10001,	/* Not set product name. */

    // Safedog error code [11000,12000)
    ERR_SIMLOCK_NOT_FIND_SAFEDOG	= 11000,			/* Not insert safedog hardware. */
	ERR_SIMLOCK_NOT_MATCH_SOFTDOG_PRODUCT	= 11001,			/* Safedog don't match. */
	ERR_SIMLOCK_CANT_LOAD_RSA				= 11002,			/* load rsa pk. */
	ERR_SIMLOCK_RSA_ENCRYPTION_PRIVATE		= 11003,			/* load rsa pk. */
	ERR_SIMLOCK_RSA_DECRYPTION_PRIVATE		= 11004,			/* load rsa pk. */
	ERR_SIMLOCK_RSA_DECRYPTION_PRIVATE_LEN	= 11005,			/* load rsa pk. */
	ERR_SIMLOCK_RSA_ENCRYPTION_PUBLIC		= 11006,
	ERR_SIMLOCK_RSA_DECRYPTION_PUBLIC		= 11007,			/* load rsa pk. */
	ERR_SIMLOCK_RSA_DECRYPTION_PUBLIC_LEN	= 11008,			/* load rsa pk. */
	ERR_SIMLOCK_RSA_SIGN_PRIVATE            = 11009,	
	ERR_SIMLOCK_RSA_UPDATEPASSWD			= 11010,
	ERR_SIMLOCK_RSA_EXPORT					= 11011,
	ERR_SIMLOCK_RSA_IMPORT					= 11012,

    // db error code [12000,13000)
    ERR_SIMLOCK_OPEN_DATABASE	= 12000,			/* Failed to open database. */
    ERR_SIMLOCK_WRITE_DATABASE	= 12001,			/* Failed to write database. */
    
	// Common error (50000~60000)
	ERR_SIMLOCK_INVALID_INPUT_PARAMETER = 60000,/* Invalid input parameter.*/ 
    ERR_SIMLOCK_UNKNOW_ERROR,				/* SIMLOCK unknow error.    */ 

    E_SIMLOCK_UNDEFINE_ERR
};
