# עורך HTML לג'ימייל - Gmail HTML Editor

תוסף Chrome שמאפשר ליצור ולערוך הודעות מייל מעוצבות ב-HTML ישירות בממשק נוח ומודרני.

![Gmail HTML Editor](icons/icon.svg)

## תכונות

✨ **עורך ויזואלי** - עריכת טקסט בסגנון WYSIWYG (מה שרואים זה מה שמקבלים)

📝 **עורך HTML** - עריכה ישירה של קוד HTML למשתמשים מתקדמים

👁️ **תצוגה מקדימה** - צפייה בתוצאה הסופית לפני השליחה

📋 **תבניות מוכנות** - ניוזלטר, הודעה, הזמנה ועוד

🎨 **כלי עיצוב מלאים**:
- גופנים וגדלים
- צבעי טקסט ורקע
- יישור טקסט
- רשימות
- קישורים
- תמונות
- טבלאות
- קווי מפריד

💾 **שמירת תבניות** - שמירת עיצובים לשימוש חוזר

## התקנה

### התקנת התוסף ב-Chrome

1. פתח את Chrome ועבור לכתובת: `chrome://extensions/`
2. הפעל את **מצב מפתח** (Developer mode) בפינה הימנית העליונה
3. לחץ על **טען תוסף שלא נארז** (Load unpacked)
4. בחר את התיקייה `AAA_gmail`
5. התוסף יותקן ויופיע האייקון בסרגל הכלים

## שימוש

1. **פתח Gmail** בדפדפן Chrome
2. **לחץ על אייקון התוסף** בסרגל הכלים
3. **צור את ההודעה** באמצעות העורך הויזואלי או קוד HTML
4. **לחץ "הכנס לג'ימייל"** כשחלון הודעה חדשה פתוח

### טיפים לשימוש

- **החלפה בין מצבים**: השתמש בלשוניות למעבר בין עורך ויזואלי, HTML ותצוגה מקדימה
- **שמירת תבניות**: שמור עיצובים מוצלחים לשימוש עתידי
- **העתקת HTML**: העתק את הקוד ללוח להדבקה באתרים אחרים
- **קיצורי מקלדת**: 
  - `Ctrl+B` - מודגש
  - `Ctrl+I` - נטוי
  - `Ctrl+U` - קו תחתון
  - `Ctrl+S` - שמירת תבנית

## מבנה הקבצים

```
AAA_gmail/
├── manifest.json      # הגדרות התוסף
├── popup.html         # ממשק המשתמש
├── popup.js           # לוגיקת העורך
├── styles.css         # עיצוב הממשק
├── content.js         # סקריפט לאינטראקציה עם Gmail
├── content-styles.css # עיצובים ל-Gmail
├── background.js      # סקריפט רקע
├── icons/
│   ├── icon16.png     # אייקון 16x16
│   ├── icon48.png     # אייקון 48x48
│   └── icon128.png    # אייקון 128x128
└── README.md          # קובץ זה
```

## פתרון בעיות

### התוסף לא מכניס תוכן לג'ימייל
- ודא שחלון הודעה חדשה (Compose) פתוח
- נסה לרענן את עמוד Gmail ולפתוח חלון הודעה חדש
- ודא שהתוסף מופעל בדף Gmail

### האייקון לא מופיע
- טען מחדש את התוסף ב-chrome://extensions/

### עיצוב לא מופיע נכון
- Gmail עשוי להסיר חלק מהסגנונות
- השתמש בסגנונות inline במקום CSS חיצוני

## רישיון

MIT License - ניתן לשימוש חופשי

## תמיכה

לשאלות ובעיות, פתח issue ב-GitHub או צור קשר.

