# אפשרויות חפיסה

<!-- toc -->

אפשרויות חפיסה שולטות בעיקר על האופן שבו אנקי מתזמן כרטיסים. מומלץ להשתמש בברירות המחדל למשך מספר שבועות כדי להתרשם מאופן הפעולה של אנקי לפני שתתחילו להתאים את האפשרויות. אנא ודאו שאתם מבינים את האפשרויות לפני שינוין, מכיוון שטעויות עלולות להפחית את היעילות של אנקי.

במחשב, בצעו אחת מהפעולות הבאות כדי לפתוח את אפשרויות החפיסה:

- לחצו על עם לחצן העכבר הימני על החפיסה הרצויה במסך הראשי.
- לאחר מכן לחצו על **אפשרויות **בתחתית המסך.
- לחלופין, לחצו על **עוד > אפשרויות** במצב מבחן.

## קבוצת הגדרות

אנקי מאפשר לכם לשתף אפשרויות בין חפיסות שונות, כדי להקל
על עדכון אפשרויות בחפיסות רבות בבת אחת. לשם כך, האפשרויות מקובצות לתוך _קבוצות הגדרות_. אם תשנו אפשרות בקבוצת הגדרות, השינוי יחול על כל החפיסות המשתמשות באותה הגדרה. כל החפיסות החדשות שנוצרות משתמשות בהגדרה "ברירת-מחדל".

כדי לשנות את האפשרויות בחפיסה אחת אך לא באחרות, לחצו על
סמל החץ בפינה הימנית העליונה של חלון אפשרויות החפיסה. תוכלו לבצע את הפעולות הבאות:

- **שמירה**: שמירת כל השינויים שביצעתם באפשרויות החפיסה.
- **הוספת קבוצת הגדרות**: הוספת הגדרה חדשה לחפיסה זו, עם אפשרויות ברירת המחדל.
- **שכפול**: שכפול ההגדרה הנוכחית שלכם, שימושי אם ברצונכם
  לשנות חלק מהאפשרויות אך לשמור על השאר כפי שהן.
- **שינוי שם**: שינוי שם קבוצת ההגדרות הנוכחית.
- **מחיקה**: מחיקת קבוצת ההגדרות הנוכחית.
- **שמירה לכל תת-החפיסות**: כמו **שמירה**, אך גם מקצה את ההגדרה שנבחרה לכל
  תת-החפיסות של החפיסה הנוכחית.

אפשרויות חפיסה אינן חלות למפרע. לדוגמה, אם תשנו אפשרות
השולטת על המרווח לאחר שגיאה בכרטיס, כרטיסים שנכשלתם בהם לפני
שינוי האפשרות עדיין ישמרו על המרווח הישן, ולא החדש.

## תת-חפיסות

אם לחפיסה שלכם יש תת-חפיסות, ואתם רוצים שלאחת או יותר מתת-החפיסות יהיו הגדרות שונות מאלו של חפיסות האב, תוכלו להקצות את אותן תת-חפיסות להגדרות קבועות מראש שונות.
כשאנקי מציג כרטיס, הוא יבדוק לאיזו תת-חפיסה הכרטיס שייך, וישתמש באפשרויות
עבור אותה חפיסה. ישנם שני חריגים:

- [המגבלות](#daily-limits) של **כרטיסים חדשים/יום** ו**חזרות מרביות/יום** של תת-חפיסה משפיעות על מספר הכרטיסים שניתן לאסוף מאותה תת-חפיסה. אך המספר הכולל של הכרטיסים שתראו במהלך סבב הלימוד שלכם נשלט על ידי המגבלות של החפיסה שבחרתם ללמוד.
- אפשרויות [סדר התצוגה](#סדר תצוגה) נלקחות מהחפיסה
  שבחרתם ללמוד, ולא מהחפיסה של הכרטיס הנוכחי.

לדוגמה, נניח שיש לכם את האוסף הבא:

    - חפיסה א' (הגדרה 1)
      - חפיסה א'::תת-חפיסה ב' (הגדרה 2)

הגדרה 1 והגדרה 2 זהות, למעט שני הבדלים:

- הגדרה 1:
  - **שלבי למידה**: `1m 10m`
  - **סדר חדשים/חזרות**: `ערבוב עם חזרות`
- הגדרה 2:
  - **שלבי למידה**: `20m 2h`
  - **סדר חדשים/חזרות**: `הצגה לאחר חזרות`

אם תבחרו ללמוד את תת-חפיסה ב':

- שלבי הלמידה עבור כל הכרטיסים החדשים יהיו `20m 2h` (הגדרה 2 חלה).
- כל הכרטיסים החדשים יוצגו לאחר החזרות (הגדרה 2 חלה).

אם תבחרו ללמוד את חפיסה א':

- שלבי הלמידה עבור כרטיסים חדשים בחפיסה א' יהיו `1m 10m` (הגדרה 1 חלה).
- שלבי הלמידה עבור כרטיסים חדשים בתת-חפיסה ב' יהיו `20m 2h` (הגדרה 2 חלה).
- כל הכרטיסים החדשים יתערבבו עם החזרות (הגדרה 1 חלה).

הערה: עקב מגבלות טכניות סימוני שלבי הלמידה מופיעים באותיות אנגליות ופירושם הוא:

- s = שניות למשל שניה אחת 1s.
- m=דקות.
- h =שעות.
- d= ימים.

## מגבלות יומיות

### כרטיסים חדשים/יום

אפשרות זו קובעת כמה כרטיסים חדשים ניתן להציג בכל יום שבו אתם פותחים את התוכנה. אם תלמדו
פחות מהמגבלה, או תפספסו יום, למחרת הספירות יתחילו מההתחלה: לא יוצגו לכם יותר כרטיסים ממה שהמגבלה שלכם מאפשרת.

כאשר לומדים חפיסה שיש בתוכה תת-חפיסות, המגבלות שנקבעו על כל תת-חפיסה שולטות על המספר המרבי של כרטיסים שנשלפים מאותה חפיסה מסוימת. המגבלות של החפיסה שנבחרה שולטות על המספר הכולל של הכרטיסים שיוצגו.

לימוד כרטיסים חדשים יגדיל באופן זמני את מספר החזרות שעליכם לבצע
ביום, מכיוון שחומר שנלמד לאחרונה צריך לחזור עליו מספר פעמים
לפני שהמרווח בין החזרות יוכל לגדול באופן ניכר. אם אתם
לומדים באופן עקבי 20 כרטיסים חדשים ביום, אתם יכולים לצפות שהחזרות היומיות שלכם יהיו בערך 200 כרטיסים ליום. אתם יכולים להפחית את מספר החזרות הנדרשות על ידי
הצגת פחות כרטיסים חדשים בכל יום עד שעומס החזרות שלכם יפחת. לא מעט משתמשי אנקי למדו בהתלהבות
מאות כרטיסים חדשים בימים הראשונים לשימוש בתוכנה, ואז הוצפו
בכמות החזרות הנדרשת.

### חזרות מרביות/יום

מאפשרת לכם לקבוע מגבלה עליונה למספר כרטיסי החזרה שיוצגו בכל יום.
כאשר מגבלה זו מושגת, אנקי לא תציג עוד כרטיסי חזרה לאותו
יום, גם אם ישנם עוד הממתינים. אם אתם לומדים באופן עקבי, הגדרה זו יכולה
לעזור להחליק עליות מזדמנות בספירות הכרטיסים המיועדים, ויכולה להציל אתכם מהתקף לב כשאתם חוזרים לאנקי לאחר שבוע חופש. כאשר חזרות
הוסתרו עקב אפשרות זו, תופיע הודעה במסך הסיכום,
המציעה לשקול להגדיל את המגבלה אם יש לכם זמן.

כאשר לומדים חפיסה שיש בתוכה תת-חפיסות, מגבלת החזרות מתנהגת בדומה למגבלת הכרטיסים החדשים.

אנקי כוללת את כל כרטיסי הלמידה ש[חצו את גבול היום](./preferences.md#חזרה) (כרטיסי למידה בין-יומיים) בספירת החזרות,
כך שכרטיסי למידה אלה יהיו כפופים למגבלת החזרות.

### מגבלות יומיות לפי חפיסה

ניתן להשתמש באותה קבוצת הגדרות עבור חפיסות שונות, עם מגבלות מותאמות אישית לכל אחת מהן. זה מבטל את הצורך ליצור הגדרות משוכפלות רק למטרה זו, ומקל על קביעת מגבלות מותאמות אישית על תת-חפיסות.

אנקי מספקת שלוש אפשרויות למגבלות יומיות:

- **כל קבוצת ההגדרות**: חלה על כל החפיסות המשתמשות בהגדרה.
- **חפיסה זו**: ספציפית לחפיסה מסוימת.
- **להיום בלבד**: ספציפית לחפיסה מסוימת, ובאופן זמני.

### התעלם ממגבלת החזרות עבור כרטיסים חדשים

כברירת מחדל, מגבלת החזרות חלה גם על כרטיסים חדשים, ולא יוצגו כרטיסים חדשים כאשר מגבלת החזרות הושגה. אם אפשרות זו מופעלת, כרטיסים חדשים יוצגו ללא קשר למגבלת החזרות.

אם יש לכם צבר של כרטיסי חזרה באיחור, מומלץ להפסיק להציג כרטיסים חדשים עד שתתעדכנו
עם אותו צבר. המשך הצגת כרטיסים חדשים כאשר אתם כבר בפיגור יכול
להחמיר את הצבר.

### חישוב מגבלות מחפיסת האב העליונה

כברירת מחדל, המגבלות היומיות של חפיסה ברמה גבוהה יותר אינן חלות אם אתם בוחרים באחת מתת-החפיסות שלה. לחפיסת אב יכולה להיות מגבלת כרטיסים חדשים של 10 כרטיסים ליום ולתת-החפיסות שלה יכולה להיות מגבלת כרטיסים חדשים של 20 כרטיסים ליום. המגבלות שנקבעו על חפיסת האב אינן משפיעות על מספר הכרטיסים החדשים שתוכלו ללמוד מתת-החפיסה שלה.

כאשר אפשרות זו מופעלת, המגבלות שנקבעו על חפיסות ברמה גבוהה יותר חלות גם על תת-החפיסות שלהן כאשר נבחרת תת-חפיסה. בדוגמה הקודמת, תוכלו ללמוד רק 10 כרטיסים חדשים מתת-החפיסות במקום 20 כרטיסים חדשים.

אפשרות זו יכולה להיות שימושית אם ברצונכם ללמוד תת-חפיסות בודדות, תוך אכיפת מגבלה כוללת על כרטיסים מכל תת-החפיסות.

## כרטיסים חדשים

האפשרויות כאן משפיעות רק על כרטיסים חדשים
ו[כרטיסים בלמידה](getting-started.md#מצבי כרטיסים). ברגע שכרטיס
סיים את שלב הלמידה (כלומר, עבר את כל שלבי הלמידה), האפשרויות בסעיף זה אינן חלות עוד על הכרטיס.

### שלבי למידה

הגדרה זו שולטת במספר חזרות הלמידה, ובמרווח
ביניהן. יש להזין מרווח אחד או יותר, מופרדים ברווחים.
בכל פעם שתלחצו על **טוב** במהלך חזרה, הכרטיס יעבור לשלב הבא. בכל פעם שתלחצו על **שוב**, הכרטיס יחזור לשלב הראשון.

לדוגמה, נניח ששלבי הלמידה שלכם הם `1m 10m 1d`.

- כאשר תלחצו על **שוב**, הכרטיס יעבור את השלב הראשון, ויוצג
  שוב לאחר דקה אחת.
- כאשר תלחצו על **טוב** על כרטיס חדש או לאחר שלב הדקה, הוא יעבור
  לשלב הבא, ויוצג שוב בעוד 10 דקות.
- כאשר תלחצו על **טוב** על כרטיס לאחר שלב 10 הדקות, הוא לא יוצג
  שוב עד למחרת.
- כאשר תלחצו על **טוב** על הכרטיס למחרת, הוא יסיים את שלב הלמידה ויהפוך
  לכרטיס חזרה. הכרטיס יוצג שוב לאחר המרווח שהוגדר על ידי
  _מרווח סיום הלמידה_.

כפתור **קשה** פועל באופן שונה בהתאם לשלב שבו אתם נמצאים.

- כאשר אתם בשלב הראשון, כפתור **קשה** מציג מרווח של `6m`. המרווח של `6m` הוא הממוצע של שני השלבים הראשונים: `1m` ו-`10m`.
  - חריג: כאשר יש רק שלב למידה אחד, כפתור **קשה** מציג מרווח של פי 1.5 מאותו שלב. מרווח זה ארוך ביום אחד לכל היותר משלב הלמידה.
- כאשר אתם בכל שלב אחר, כפתור **קשה** חוזר על אותו שלב.

אם אין שום דבר אחר ללמוד, אנקי תציג כרטיסי למידה עד 20 דקות
מוקדם יותר כברירת מחדל. כדי לבטל זאת או לשנות את משך הזמן להסתכל קדימה, ראו [העדפות](preferences.md).

#### גבולות יום

אנקי מתייחסת לשלבים קצרים ולשלבים ש[חוצים גבול יום](./preferences.md#חזרה) באופן שונה.
בשלבים קצרים, הכרטיסים מוצגים ברגע שהמרווח חלף,
בעדיפות על פני כרטיסי חזרה וכרטיסים חדשים. זה נעשה כדי
שתוכלו לענות על הכרטיס קרוב ככל האפשר למרווח המבוקש.
לעומת זאת, אם השלב חוצה גבול יום, המרווח מומר אוטומטית לימים. לדוגמה, אם היום הבא מתחיל בעוד 5 שעות והמרווח הוא 6 שעות, אנקי ממיר את המרווח ליום אחד.

### מרווח סיום למידה

מספר הימים שיש להמתין לפני הצגה חוזרת של כרטיס, לאחר שימוש בכפתור "טוב" בשלב הלמידה האחרון. זה אומר שזהו המרווח הראשון
לאחר שכרטיס הלמידה מסיים את שלב הלמידה. אנא ראו את הדוגמה
מ[מוקדם יותר בסעיף זה](deck-options.md#שלבי למידה).

### מרווח קל

מספר הימים שיש להמתין לפני הצגה חוזרת של כרטיס, לאחר שימוש בכפתור "קל" עליו.

כפתור **קל** הופך כרטיסי למידה לכרטיסי חזרה ללא קשר לשלב שבו אתם נמצאים,
ומקצה להם את המרווח שהגדרתם באפשרות זו. מרווח קל צריך להיות תמיד לפחות
ארוך כמו מרווח סיום הלמידה, ובדרך כלל ארוך בכמה ימים.

### סדר הוספה

הגדרה זו קבעה בגרסאות ישנות אם אנקי צריך להוסיף כרטיסים חדשים לחפיסה באופן אקראי, או סדרתי.
כאשר תשנו אפשרות זו, אנקי ימיין מחדש את החפיסות בהגדרה הנוכחית.

למעשה הגדרה זו אינה משנה דבר ועליכם להשאיר אפשרות זו על `לפי סדר הוספה`, ולהתאים את [סדר התצוגה](deck-options.md#סדר חזרה) במקום זאת.

## שגיאות

כאשר אתם לוחצים על **שוב** על כרטיס במהלך חזרה, זה נקרא _שגיאה_. האפשרויות המפורטות כאן משפיעות על כרטיסים כאלה שנכשלו.

### שלבי למידה מחדש

זהה לשלבי למידה, אך עבור כרטיסים שנכשלו. כאשר אתם נכשלים בכרטיס חזרה
(לוחצים **שוב**), הכרטיס עובר _שלבי למידה מחדש_, לפני שהוא הופך שוב לכרטיס חזרה.

אם תשאירו את השלבים ריקים, הכרטיס ידלג על למידה מחדש, ויוקצה לו
מרווח חדש של יום אחד כברירת מחדל.

### מרווח מינימלי

מציין מספר ימים מינימלי שכרטיס צריך להמתין לאחר שהוא מסיים למידה מחדש.
ברירת המחדל היא יום אחד, כלומר ברגע שהלמידה מחדש מסתיימת, הוא יוצג שוב
למחרת.

### עלוקות

קובע כיצד אנקי מטפל בעלוקות. לפרטים, ראו את סעיף
ה[עלוקות](leeches.md).

## סדר חזרה

האפשרויות בסעיף זה קובעות על החפיסה שבחרתם ללמוד במסך הראשי, ולא
על החפיסה של הכרטיס המוצג כעת.

מידע נוסף על סדר התצוגה זמין ב[סעיף הלימוד](studying.md#סדר התצוגה).

### סדר איסוף כרטיסים חדשים

שולט על האופן שבו אנקי אוסף כרטיסים חדשים מחפיסה. האפשרויות הן:

- **חפיסה**: אוסף כרטיסים מכל תת-חפיסה לפי הסדר, החל מהעליונה. כרטיסים מכל
  תת-חפיסה נאספים במיקום עולה. אם מגבלת היום של החפיסה שנבחרה
  הושגה, האיסוף עשוי להיעצר לפני שסיימתם חזרה על כל תת-החפיסות. סדר
  זה הוא המהיר ביותר באוספים גדולים, ומאפשר לכם לתעדף תת-חפיסות
  שקרובות יותר לחלק העליון.

  חפיסות/תת-חפיסות מסודרות תמיד בסדר אלפביתי, כך שתוכלו לתת להן קידומת מספרית כמו
  001 כדי לשלוט בסדר הופעתן. תוכלו גם להשתמש ב-`_` וב-`~` כ
  קידומת כדי למקם פריטים בחלק העליון או התחתון.

  למרות שסדר המיקום תלוי בתחילה באפשרות סדר ההוספה, תוכלו
  [למקם מחדש](./browsing.md#כרטיסים) כרטיסים באופן ידני בדרכים
  שונות.

- **חפיסה, ואח"כ רשומות אקראיות**: אוסף כרטיסים מכל תת-חפיסה לפי הסדר, החל מהעליונה.
  כרטיסים מכל תת-חפיסה נאספים מרשומות שנבחרו באופן אקראי.

- **מיקום עולה**: אוסף כרטיסים לפי מיקום עולה (מספר יעד), שבדרך כלל מתחיל מהישן ביותר שהוסף.

- **מיקום יורד**: אוסף כרטיסים לפי מיקום יורד (מספר יעד), שבדרך כלל הוא מהחדש ביותר שהוסף.

- **רשומות אקראיות**: אוסף כרטיסים מרשומות שנבחרו באופן אקראי.

- **כרטיסים אקראיים**: אוסף כרטיסים בסדר אקראי.

### סדר חזרה של כרטיסים חדשים

שולט על אופן המיון של כרטיסים חדשים לאחר שנאספו. האפשרויות הן:

- **תבנית כרטיס, ואז סדר איסוף**: מציג כרטיסים לפי סדר מספר סוג הכרטיס. כרטיסים מכל מספר סוג כרטיס מוצגים בסדר שבו נאספו. אם הטמנת אחים מושבתת, זה מבטיח שכל כרטיסי קדימה←אחורה נראים לפני כל כרטיסי אחורה←קדימה.
  סדר זה שימושי אם אינכם רוצים שכרטיסים אחים יופיעו קרוב מדי זה לזה.

- **סדר איסוף**: מציג כרטיסים בדיוק כפי שנאספו. אם הטמנת אחים מושבתת, זה בדרך כלל גורם לכך שכל הכרטיסים האחים מופיעים בזה אחר זה.

- **תבנית כרטיס, ואז אקראי**: מציג כרטיסים לפי סדר מספר סוג הכרטיס, אך מערבב את הכרטיסים של כל מספר סוג כרטיס.
  סדר זה שימושי אם אינכם רוצים שכרטיסים אחים יופיעו קרוב מדי זה לזה, אך עדיין רוצים שהכרטיסים יופיעו בסדר אקראי.

- **רשומה אקראית, ואז תבנית כרטיס**: בוחר רשומות באופן אקראי, ואז מציג את כל אחיהם לפי הסדר.

- **אקראי**: מערבב לחלוטין את הכרטיסים שנאספו.

### סדר חדש/חזרה

האם כרטיסים חדשים צריכים להתערבב עם כרטיסי חזרה, להיות מוצגים לפניהם, או להיות מוצגים לאחריהם.

### סדר למידה בין-יומית/חזרות

האם כרטיסי למידה (או למידה מחדש) שחוצים גבול יום צריכים להתערבב עם כרטיסי חזרה,
להיות מוצגים לפניהם, או להיות מוצגים אחריהם. מכיוון שכרטיסי למידה נוטים להיות קשים יותר
מכרטיסי חזרה, חלק מהמשתמשים מעדיפים לראות אותם בסוף (לבצע את הדברים הקלים
תחילה), או בהתחלה (מה שמאפשר יותר זמן לחזור על אלה שנשכחו).

### סדר מיון חזרות

שולט על אופן המיון של כרטיסי חזרה. האפשרויות הן:

- **תאריך יעד, ואז אקראי**: סדר ברירת המחדל מתעדף כרטיסים שהמתינו
  יותר זמן, וזהו הסדר המומלץ כאשר אתם מעודכנים, או כאשר יש לכם רק צבר
  קטן. אם לקחתם הפסקה ממושכת או פיגרתם בחזרות שלכם,
  ייתכן שתרצו לשקול לשנות את סדר המיון באופן זמני.
- **תאריך יעד, ואז חפיסה**: זה גם מתעדף כרטיסים שהמתינו
  יותר זמן, ואז מציג כרטיסי חזרה עבור כל תת-חפיסה בתורה.
- **חפיסה, ואז תאריך יעד**: מציג כרטיסי חזרה עבור כל
  תת-חפיסה בתורה. סדר זה בדרך כלל אינו מומלץ, מכיוון שהופעת חומר
  באופן עקבי באותו סדר מקלה על ניחוש התשובה על סמך הקשר,
  ומובילה לזיכרונות חלשים יותר.
- **מרווחים עולים**: מציג כרטיסים עם מרווחים קצרים יותר תחילה.
- **מרווחים יורדים**: מציג כרטיסים עם מרווחים ארוכים יותר תחילה.
- **רמת קלות עולה**: מציג כרטיסים קשים יותר תחילה.
- **רמת קלות יורדת**: מציג כרטיסים קלים יותר תחילה.
- **פיגור יחסי**: מציג כרטיסים שסביר יותר ששכחתם תחילה. זה מומלץ בדרך כלל אם
  יש לכם צבר גדול שייקח זמן לעבור עליו, ואתם רוצים
  להפחית את הסיכוי לשכוח עוד כרטיסים.

  בעת שימוש באלגוריתם SM-2, הפיגור נקבע על ידי השוואת מידת
  הפיגור של הכרטיסים, ואורך המרווח שלהם. לדוגמה, כרטיס עם
  מרווח נוכחי של 5 ימים שנמצא בפיגור של יומיים, יוצג לפני כרטיס
  עם מרווח נוכחי של 10 ימים שנמצא בפיגור של 3 ימים.

  כאשר FSRS מופעל, סדר מיון זה מוסר; המקבילה ב-FSRS היא **יכולת אחזור עולה**,
  המחושבת על בסיס היכולת אחזור של כל כרטיס (הסתברות להיזכרות) והשימור הרצוי בהגדרה.

## הטמנה

כאשר אנקי אוסף כרטיסים, הוא אוסף תחילה כרטיסי למידה תוך-יומיים(מהיום הזה), לאחר מכן כרטיסי למידה בין-יומיים, אחר כך כרטיסי חזרה, ולבסוף כרטיסים חדשים. זה משפיע על אופן הפעולה של ההטמנה:

- אם כל אפשרויות ההטמנה שלכם מופעלות, האח שמופיע הכי מוקדם ברשימה זו יוצג. לדוגמה, כרטיס חזרה יוצג בעדיפות על פני כרטיס חדש.
- אחים מאוחרים יותר ברשימה אינם יכולים להטמין סוגי כרטיסים מוקדמים יותר. לדוגמה, אם תכבו את הטמנת הכרטיסים החדשים, ותלמדו כרטיס חדש, הוא לא יטמין שום כרטיס למידה בין-יומי או כרטיס חזרה, וייתכן שתראו גם אח חזרה וגם אח חדש באותו סבב לימוד.

האפשרויות הן:

- **הטמן אחים חדשים**: האם כרטיסים חדשים אחרים מאותה רשומה (למשל, כרטיסים הפוכים, השלמות חסר סמוכות) יידחו עד למחרת.
- **הטמן אחים במצב חזרה**: האם כרטיסי חזרה אחרים מאותה רשומה יידחו עד למחרת.
- **הטמן אחים במצב לימוד בין יומיים**: האם כרטיסי למידה אחרים מאותה רשומה שחצו גבול יום יידחו עד למחרת.

למידע נוסף על הטמנת כרטיסים, אנא ראו [סעיף זה](./studying.md#אחים והטמנה) במדריך.

## שמע

- **אל תפעיל שמע אוטומטית**: כברירת מחדל, אנקי מנגן אוטומטית כל שמע שיש לכם
  בכרטיסים. אם תפעילו אפשרות זו, אנקי לא ינגן שמע עד שתלחצו על מקש ניגון השמע מחדש, <kbd>R</kbd> או <kbd>F5</kbd>.

- **דלג על השאלה בניגון חוזר של התשובה**: קובע האם שמע מצד
  השאלה ינוגן כאשר אתם משתמשים בפעולת הניגון החוזר בצד התשובה. שימו לב שאנקי [לא מנגן אוטומטית](./templates/fields.md#special-fields) שמע משדה `{{FrontSide}}`. אפשרות זו אינה משפיעה על התנהגות הניגון האוטומטי.

## שעון עצר

<a id="timer"></a>

אנקי עוקב אחר משך הזמן שלוקח לכם לענות על כל כרטיס, כדי שתוכלו
לראות כמה זמן הושקע בלימוד בכל יום. הזמן שנלקח אינו
משפיע על התזמון.

### קוצב זמן פנימי

- מקסימום שניות לתשובה: מגבלת ברירת המחדל היא 60 שניות. אם לוקח
  לכם יותר מזה, אנקי מניח שהתרחקתם מהמחשב
  או שהוסחה דעתכם, ומגביל את הזמן המתועד ל-60 שניות, כך
  שלא תסיימו עם סטטיסטיקות לא מדויקות.
- קוצב זמן פנימי זה פועל מהרגע שהשאלה מוצגת ועד שאתם לוחצים על כפתור כדי לדרג את תשובתכם. אם אתם באופן עקבי
  משקיעים יותר מ-60 שניות בכרטיס,
  ייתכן שתרצו לשקול להעלות
  את המגבלה הזו, או אפילו טוב יותר- להפוך את הכרטיסים שלכם לפשוטים יותר.

### קוצב זמן על המסך

- הצג טיימר על המסך: במסך הלימוד, הצג קוצב זמן הסופר את הזמן
  שאתם לוקחים ללמוד כל כרטיס. (קוצב זמן זה ייעצר כשיגיע לשניות המרביות למענה שהוגדרו עבור קוצב הזמן הפנימי.)
- עצור טיימר בתשובה: האם קוצב הזמן על המסך ימשיך לפעול מהרגע שבו אתם מציגים
  את התשובה ועד שאתם לוחצים על כפתור כדי לדרג את תשובתכם. אפשרות זו אינה משפיעה על הזמן שמתועד לסטטיסטיקות שלכם.

## התקדמות אוטומטית

התקדמות אוטומטית מאפשרת לכם לבצע פעולות מסוימות באופן אוטומטי לאחר שחלף זמן מסוים. כדי להשתמש בזה, עליכם תחילה להגדיר זמן שאינו אפס
ב**שניות המתנה בהצגת שאלה** ו/או **שניות המתנה בהצגת תשובה**. לאחר מכן, במסך
הלימוד, השתמשו בפעולת ההתקדמות האוטומטית מכפתור **אפשרויות נוספות** כדי להתחיל להתקדם.

**המתן לשמע** קובע האם הפעולה הנבחרת תתחיל לפני שהשמע בשאלה/תשובה יסתיים .

## ימים קלים

אם אתם רוצים להשקיע פחות זמן באנקי בימים מסוימים בשבוע, כמו ימי שישי-שבת, תכונה זו יכולה לעזור לכם לעשות זאת.
לאחר חישוב המרווח, הוא יותאם במעט כדי לשנות את תאריך היעד.
שימו לב שהגדרת כל הימים ל"מופחת" או "מינימלי" תביא לאותו עומס עבודה כמו הגדרת כל הימים ל"רגיל".
תכונה זו עובדת הן עם FSRS והן עם אלגוריתם SM-2 הוותיק.
שינוי תצורת הימים הקלים שלכם אינו משנה מרווחים קיימים למפרע
וישפיע רק על מרווחים עתידיים. במילים פשוטות, לא תראו שינויים מיידיים במספר הכרטיסים המיועדים.

## FSRS

מתזמן החזרה המרווחת החופשי (FSRS) הוא חלופה לאלגוריתם הוותיק של אנקי
SuperMemo 2 (SM-2). על ידי קביעה מדויקת יותר של כמות המידע שאתם צפויים
לשכוח, הוא יכול לעזור לכם לזכור יותר חומר באותו פרק זמן.

כאשר אתם מפעילים את FSRS, כמה אפשרויות חדשות
הופכות זמינות, ואפשרויות ספציפיות ל-SM-2, כגון **מרווח סיום למידה**,
**בונוס קל**, וכו' מוסתרות. אפשרות זו משותפת לכל ההגדרות הקבועות מראש.

### מדריך קצר

- הפעילו את FSRS תחת סעיף "FSRS", בתחתית דף אפשרויות החפיסה. ניתן להפעיל את FSRS רק באופן גלובלי; לא ניתן להפעיל אותו עבור חלק מקבוצות ההגדרות ולכבות אותו עבור אחרות.
- ודאו שכל [שלבי הלמידה](#שלבי למידה) ו[הלמידה מחדש](#שלבי למידה מחדש) שלכם קצרים מיום אחד וניתן להשלים אותם באותו יום. 23 שעות אינן מומלצות למרות שזה פחות מיום אחד, כי לא תוכלו לסיים שלב זה באותו יום כמו החזרה הראשונה שלכם. שלבים כמו 10 דקות או 30 דקות הם טובים.
- לחצו על כפתור "בצע אופטימיזציה" תחת השדה "פרמטרי FSRS". אם אתם רואים הודעה שאומרת "נראה כי פרמטרי FSRS הם אופטימליים כעת", זה בסדר.
- בחרו ערך של [שימור רצוי](#שימור רצוי): אחוז הכרטיסים שתזכרו בהם בהצלחה כשהם מיועדים לחזרה. **זוהי ההגדרה החשובה ביותר ב-FSRS. שימור גבוה יותר מוביל למרווחים קצרים יותר ויותר חזרות ביום.** ברירת המחדל היא 90%, המציעה איזון טוב בין שימור ועומס עבודה. מעל 90% עומס העבודה גדל במהירות רבה, ומעל 97% עומס העבודה יכול להיות מכריע. תוכלו להשתמש ב["חשב שימור מינימלי מומלץ"](#compute-minimum-recommended-retention) כדי לעזור לכם לבחור את ערך השימור הרצוי.
  פרמטרים ושימור רצוי הם ספציפיים להגדרה, תוכלו ליצור מספר הגדרות עם פרמטרים ושימור רצוי שונים.

FSRS יכול להסתגל כמעט לכל הרגל, למעט אחד: לחיצה על "קשה" במקום "שוב" כאשר אתם שוכחים את התשובה. כאשר אתם לוחצים על "קשה", FSRS מניח שנזכרתם במידע נכון (אם כי בהיסוס ועם מאמץ מנטלי רב). אם תלחצו על "קשה" כאשר נכשלתם בזכירת התשובה, כל המרווחים יהיו גבוהים באופן בלתי סביר. לכן, אם יש לכם הרגל זה, אנא שנו אותו והשתמשו ב"שוב" כאשר אתם שוכחים את התשובה.

לגבי תזמון ידני, לא מומלץ לתזמן כרטיסים באופן ידני. אם הם קלים ואתם רוצים להגדיל את המרווח שלהם- לזה יספיקו כמה חזרות בודדות שבהם תלחצו על "קל". אם אינכם יודעים את התשובה לחצו על "שוב". זה לא יגדיל בהרבה את עומס החזרות מכיון שגם אחרי לחיצה על שוב מרווחי הכרטיס לא יהיו כמו כרטיס חדש.

### שימור רצוי

שימור רצוי שולט על הסבירות שתזכרו כרטיסים כאשר הם מתוזמנים לחזרה.
ערך ברירת המחדל של `0.90` יתזמן כרטיסים כך שתהיה לכם סבירות של 90% לזכור
אותם כשהם יופיעו לחזרה שוב. זה אמור בדרך כלל לתרגם לזכירת כ-90% מהכרטיסים כאשר הם מופיעים לחזרה, ושגיאה בכ-10% בלבד.

הנה גרף שמראה כיצד התאמת ערך זה תשפיע על עומס העבודה שלכם:

![גרף המציג עלייה אקספוננציאלית בעומס העבודה ככל ששיעור השימור הרצוי מתקרב לאחד.](./media/FSRS_retention.png)

הצורה המדויקת של הגרף שונה עבור כל אחד. עם זאת, ישנם שני דפוסים שנכונים לכולם:

- ככל ששיעור השימור הרצוי מתקרב ל-1.0, עומס העבודה גדל באופן דרסטי.
  דמיינו שיש לכם כרטיס עם סיכוי של 90% לזכור אותו לאחר 100 ימים. אם שיעור השימור הרצוי שלכם הוא `0.90`, תחזרו על הכרטיס שוב בעוד 100 ימים. אבל אם שיעור השימור הרצוי שלכם הוא `0.95`, תצטרכו לחזור עליו לאחר 46 ימים במקום זאת.
  זה אומר שהמרווחים של הכרטיסים שלכם כמעט יורדים בחצי בשיעור שימור של `0.95` ואתם צריכים לחזור על כרטיסים בתדירות כפולה בהשוואה לשיעור שימור של `0.90`.
  ב-`0.97`, המרווח יהיה 27 ימים (תצטרכו לחזור על הכרטיסים שלכם בתדירות של פי 3.7).
  ב-`0.99`, המרווח יהיה רק 9 ימים (תצטרכו לחזור על הכרטיסים שלכם בתדירות של יותר מפי 10 מאשר עם ברירות המחדל).

- ככל ששיעור השימור הרצוי יורד, תשכחו אחוז גדול יותר מהכרטיסים
  שלכם, ותאלצו לחזור על אותם כרטיסים שוב. בסופו של דבר, תגיעו
  לנקודה שבה הכרטיסים הנשכחים תורמים יותר לעומס העבודה שלכם
  מאשר מה שאתם מרוויחים מהמרווחים הארוכים יותר. כמו כן, זכרו שלשכוח
  חומר לעתים קרובות זה דבר מוריד מוטיבציה.

מסיבות אלה, אנו מציעים שתהיו שמרניים בעת התאמת מספר זה,
וממליצים לשמור אותו נמוך מ-`0.97` וגבוה מ[שיעור השימור המינימלי המומלץ](#חשב שימור מינימלי מומלץ).

### פרמטרי FSRS

פרמטרי FSRS משפיעים על אופן תזמון הכרטיסים. אל תשנו את הפרמטרים באופן ידני או תעתיקו אותם ממישהו אחר.

**אופטימיזציה של פרמטרי FSRS**

ממטב ה-FSRS משתמש בלמידת מכונה כדי ללמוד את דפוסי הזיכרון שלכם ולמצוא פרמטרים המתאימים ביותר להיסטוריית החזרות שלכם. לשם כך, הממטב דורש מספר חזרות כדי לכוונן את הפרמטרים.

כאשר תלחצו על כפתור **בצע אופטימיזציה**, FSRS ינתח את היסטוריית החזרות שלכם, וייצר פרמטרים אופטימליים עבור הזיכרון שלכם והתוכן שאתם לומדים. אם יש לכם חפיסות השונות באופן קיצוני בקושי שלהן, מומלץ
להקצות להן הגדרות נפרדות, שכן הפרמטרים עבור חפיסות קלות יותר
יהיו שונים מאלו של חפיסות קשות יותר. אין צורך לבצע אופטימיזציה של
הפרמטרים שלכם לעתים קרובות: פעם בחודש מספיקה.

כברירת מחדל, הפרמטרים מחושבים מהיסטוריית החזרות של כל
החפיסות המשתמשות בהגדרה הנוכחית. תוכלו [להתאים את החיפוש](./searching.md)
באופן אופציונלי לפני ביצוע אופטימיזציה של הפרמטרים, אם תרצו להחריג כרטיסים מסוימים שלא ישמשו לאופטימיזציה.

תוכלו גם לבצע אופטימיזציה של הפרמטרים עבור כל קבוצות ההגדרות שלכם בבת אחת על ידי לחיצה על **בצע אופטימיזציה לכל ההגדרות**.

**הערכה של פרמטרי FSRS**

תוכלו להשתמש בכפתור **הערכה** כדי לראות מדדים המראים עד כמה הפרמטרים מתאימים להיסטוריית החזרות שלכם. מספרים קטנים יותר
מצביעים על התאמה טובה יותר להיסטוריית החזרות שלכם.

ל-Log loss אין פרשנות אינטואיטיבית. ניתן לפרש את RMSE (bins)
כפער הממוצע בין ההסתברות החזויה
לזכירת כרטיס (R) לבין ההסתברות
האמיתית שנמדדה מהיסטוריית החזרות שלכם. לדוגמה, RMSE=5% אומר שבממוצע, FSRS
טועה ב-5% בחיזוי R. אינכם צריכים להבין מדדים אלה כדי להשתמש ב-FSRS.

שימו לב ש-Log loss ו-RMSE (bins) אינם מתואמים באופן מושלם,
כך שלשתי חפיסות עשויים להיות ערכי RMSE דומים אך ערכי log-loss שונים מאוד, או להפך.

כברירת מחדל, Log loss ו-RMSE (bins) מחושבים מכל החפיסות המשתמשות בהגדרה הנוכחית. תוכלו [להתאים את החיפוש](./searching.md) באופן אופציונלי לפני הערכת הפרמטרים, אם תרצו לשנות אילו כרטיסים משמשים להערכה.

### תזמן מחדש כרטיסים בעת שינוי

אפשרות זו קובעת האם תאריכי היעד של כרטיסים ישתנו כאשר תפעילו את FSRS, תשנו את שיעור השימור הרצוי, או תשנו את הפרמטרים. ברירת המחדל היא לא לתזמן מחדש כרטיסים: חזרות עתידיות ישתמשו בתזמון החדש, אך לא יהיה שינוי מיידי בעומס העבודה שלכם. אם תזמון מחדש מופעל, תאריכי היעד של כרטיסים ישתנו. בהתאם לשיעור השימור הרצוי שלכם, זה יגרום לעתים קרובות למספר גדול של כרטיסים להפוך למיועדים לחזרה, ולכן **אפשרות זו אינה מומלצת** בעת המעבר הראשוני מ-SM-2.

השתמשו באפשרות זו במשורה, שכן היא תוסיף רשומת חזרה לכל אחד מהכרטיסים שלכם, ותגדיל את גודל האוסף שלכם.

אם אתם עוברים לראשונה מ-SM-2 ועדיין רוצים להשתמש באפשרות זו, אנו ממליצים ליצור תחילה גיבוי, להפעיל את FSRS עם תזמון מחדש, ואז במידת הצורך, תוכלו לבטל או לשחזר מהגיבוי.

### חשב שימור מינימלי מומלץ

חישוב שימור מינימלי מומלץ (CMRR) מנסה למצוא את ערך השימור הרצוי שמוביל לכמות החומר הנלמד הגדולה ביותר, בזמן הקצר ביותר. המספר המחושב יכול לשמש כנקודת ייחוס בעת ההחלטה על מה להגדיר את שיעור השימור הרצוי שלכם. ייתכן שתרצו לבחור שיעור שימור רצוי גבוה יותר, אם אתם מוכנים להשקיע יותר זמן לימוד תמורת שיעור שימור גבוה יותר. עם זאת, הגדרת שיעור השימור הרצוי שלכם נמוך מהמינימום אינה מומלצת, מכיוון שתשקיעו יותר זמן בלימוד מהנדרש, עקב שכחה מוגברת.

### הסימולטור

תוכלו להשתמש בסימולטור כדי לקבל הערכה של עומס העבודה שלכם,
בין אם בחזרות ליום או בדקות לימוד ליום.

- **ימים לסימולציה** קובע את משך היסטוריית הלימוד המדומה.
- **כרטיסים חדשים נוספים לסימולציה** קובע האם הסימולטור צריך
  לדמות יותר כרטיסים ממה שכבר יש להגדרה זו. לדוגמה, אם יש לכם כעת 100 כרטיסים תחת הגדרה זו,
  ותגדירו **כרטיסים חדשים נוספים לסימולציה** ל-50, הסימולטור ידמה סך של 150 כרטיסים.
  זה יכול להיות שימושי אם אתם מתכננים ליצור עוד כרטיסים חדשים בעתיד.
- **כרטיסים חדשים/יום** ו**חזרות מרביות/יום** קובעים כמה כרטיסים חדשים יילמדו בכל יום ו
  את המספר המרבי של חזרות ביום.
- **מרווח מרבי** קובע את אורך המרווח המרבי (בימים).

כדי להפוך את הסימולציה למציאותית ככל האפשר, הסימולטור לוקח בחשבון את מצבי הזיכרון האמיתיים (קושי, יציבות, שליפות) של הכרטיסים שלכם.
הוא גם משתמש בפרמטרי FSRS שלכם ובערך השימור הרצוי, ולכן שינויים בהם ישפיעו על הסימולציה.

#### שלבי למידה ולמידה מחדש

שלבי למידה (ולמידה מחדש) של יום אחד או יותר אינם מומלצים בעת שימוש ב-FSRS. הסיבה
העיקרית שהם היו פופולריים עם אלגוריתם SM-2 הוותיק היא ששגיאה
חוזר בכרטיס לאחר שסיים את שלב הלמידה עלול היה להפחית
את רמת הקלות שלו באופן משמעותי, מה שהוביל למה שחלק כינו "גיהינום הקלות". זו לא
בעיה ש-FSRS סובל ממנה. על ידי שמירה על שלבי למידה של פחות מיום,
תאפשרו ל-FSRS לתזמן כרטיסים בזמנים שהוא חישב כאופטימליים
עבור החומר והזיכרון שלכם. סיבה נוספת לא להשתמש
בשלבי למידה ארוכים יותר היא ש-FSRS עשוי בסופו של דבר לתזמן את החזרה הראשונה לזמן
קצר יותר משלב הלמידה האחרון שלכם, מה שיוביל לכך שכפתור **קשה**
יציג זמן ארוך יותר מאשר **טוב**.

אנו ממליצים גם לשמור על מספר שלבי הלמידה למינימום. עדויות
מראות שחזרה על כרטיס מספר פעמים ביום אחד אינה תורמת באופן משמעותי
לזיכרון לטווח ארוך, כך שזמנכם מנוצל
טוב יותר על כרטיסים אחרים או על סבב לימוד קצר יותר.

בגרסה זו של אנקי תוכלו לתת ל-FSRS לשלוט בתזמון לטווח קצר על ידי השארת שדה שלבי הלמידה (ולמידה מחדש) ריק. זוהי תכונה ניסיונית.
שימו לב שרק בגלל ש-FSRS-5 _יכול_ לתת לכם מרווחים קצרים מיום אחד, זה לא בהכרח אומר שהוא _יעשה_ זאת. מרווח **שוב** שלכם יכול להיות באורך יום אחד, או אפילו ארוך יותר.

## מתקדם

### מרווח מרבי

מספר הימים המרבי שכרטיס חזרה ימתין לפני שיוצג שוב. כאשר חזרות הגיעו למגבלה, **קשה**, **טוב** ו**קל** ייתנו כולם את אותו מרווח. ככל שתגדירו מרווח קצר יותר, כך עומס העבודה שלכם יהיה גדול יותר. ברירת המחדל היא 100 שנים; תוכלו להקטין זאת למספר קטן יותר אם אתם מוכנים להשקיע זמן לימוד נוסף תמורת שימור גבוה יותר.

### שימור היסטורי

הגדרה זו מוסתרת אלא אם FSRS מופעל.

כאשר חלק מהיסטוריית החזרות שלכם חסר, FSRS צריך למלא את החסר. כברירת מחדל, הוא יניח שכאשר ביצעתם את החזרות הישנות הללו, זכרתם 90% מהחומר. אם שיעור השימור הישן שלכם היה גבוה או נמוך משמעותית מ-90%, התאמת אפשרות זו תאפשר ל-FSRS לאמוד טוב יותר את החזרות החסרות.

היסטוריית החזרות שלכם עשויה להיות לא שלמה משתי סיבות:

- כי אתם משתמשים באפשרות **התעלם מכרטיסים שנלמדו לפני**.
- כי מחקתם בעבר יומני חזרות כדי לפנות מקום, או ייבאתם חומר מתוכנת  חזרה אחרת.

האפשרות השנייה נדירה למדי, כך שאלא אם אתם משתמשים באפשרות הראשונה, כנראה שאינכם צריכים להתאים הגדרה זו.

### התעלם מחזרות לפני

אם מוגדר, כרטיסים שנלמדו לפני התאריך שצוין לא יילקחו בחשבון בעת אופטימיזציה של פרמטרי FSRS. זה יכול להיות שימושי אם ייבאתם נתוני תזמון של מישהו אחר, או ששיניתם את אופן השימוש שלכם בכפתורי התשובה.

### רמת קלות התחלתית

קובעת את רמת הקלות שבה כרטיסים מתחילים. היא
נקבעת כאשר כרטיס מסיים את שלב הלמידה בפעם הראשונה. ברירת המחדל
היא 2.50, כלומר לאחר שסיימתם ללמוד כרטיס, מענה **טוב**
בחזרות הבאות יגדיל את המרווח בכ-2.5x (למשל, אם המרווח האחרון היה 10 ימים, המרווח הבא יהיה סביב 25
ימים). בהתבסס על האופן שבו אתם מדרגים את הכרטיס בחזרות הבאות,
רמת הקלות עשויה לעלות או לרדת מערכה ההתחלתי.

### בונוס קל

מכפיל נוסף המוחל על המרווח כאשר כרטיס חזרה נענה
**קל**. עם ערך ברירת המחדל של 1.30, **קל** ייתן מרווח שהוא
פי 1.3 מהמרווח של "טוב" (למשל, אם המרווח של "טוב" היה 10 ימים, המרווח של "קל"
יהיה סביב 13 ימים).

### מכפיל מרווח

מכפיל נוסף המוחל על כל החזרות. בברירת המחדל של 1.00 הוא
לא עושה כלום. אם תגדירו אותו ל-0.80, המרווחים יקטנו ל
-80% מגודלם הרגיל (כך שמרווח של 10 ימים יהפוך ל-8 ימים).
תוכלו אפוא להשתמש במכפיל כדי להפוך את החזרות שלכם לתכופות פחות או יותר.

עבור חומר בקושי בינוני, המשתמש הממוצע אמור לגלות שהוא
זוכר כ-90% מ[הכרטיסים הבוגרים](getting-started.md#מצבי כרטיסים) כשהם מופיעים לחזרה. תוכלו
לגלות את הביצועים שלכם על ידי פתיחת הגרפים/סטטיסטיקות עבור חפיסה
והסתכלות על גרף כפתורי התשובה - שימור בוגר הוא
אחוז הנכונות בצד ימין של הגרף. אם לא למדתם
זמן רב, ייתכן שאין לכם עדיין כרטיסים בוגרים. מכיוון שהביצועים עם כרטיסים חדשים
וכרטיסים צעירים יותר יכולים להשתנות במידה ניכרת, כדאי לחכות
עד שיהיו לכם מספר סביר של חזרות בוגרות לפני שתתחילו
להסיק מסקנות לגבי שיעור השימור שלכם.

באתר האינטרנט של SuperMemo, הם מציעים שתוכלו למצוא מכפיל
מתאים לשיעור שימור רצוי. הנוסחה שלהם מסתכמת ב:

    log(שימור רצוי%) / log(שימור נוכחי%)

דמיינו שיש לנו שיעור שימור נוכחי של 85% ואנו רוצים להגדיל
אותו ל-90%. נחשב את המכפיל כך:

    log(90%) / log(85%) = 0.65

אם תזינו את התוצאה 65% במכפיל המרווח, תגלו
עם הזמן שהשימור שלכם מתקרב לשימור הרצוי
שלכם.

דבר חשוב אחד שיש לציין הוא שהפשרה בין זמן
הלימוד המושקע לבין השימור אינה ליניארית: אנו יכולים לראות כאן שכדי
להגדיל את השימור שלנו ב-5 נקודות אחוז, נצטרך ללמוד בתדירות של 35%
יותר. אם החומר שאתם לומדים חשוב מאוד, אז
זה עשוי להיות שווה את המאמץ הנוסף - זה, כמובן, משהו שתצטרכו
להחליט בעצמכם. אם אתם פשוט מודאגים שאתם שוכחים יותר מדי,
אז ייתכן שתגלו שהשקעת יותר זמן בשלב הלמידה הראשוני, או שימוש במנמוניקה ייתן לכם יותר רווח בפחות מאמץ.

דבר אחרון שיש לציין הוא שאנקי כופה על מרווח חדש להיות לפחות
יום אחד ארוך יותר ממה שהיה קודם, כדי שלא תתקעו
בחזרה עם אותו מרווח לנצח. אם מטרתכם היא לחזור על
כרטיס פעם ביום למשך מספר ימים, תוכלו לעשות זאת על ידי הגדרת
יותר שלבים במצב למידה, במקום על ידי התאמת מכפיל זה.

### מרווח קשה

המכפיל המוחל כאשר אתם משתמשים בכפתור **קשה**. האחוז הוא יחסי
למרווח הקודם, למשל, עם ברירת מחדל של 1.20, כרטיס עם מרווח של 10 ימים
יקבל 12 ימים.

### מרווח חדש

המכפיל המוחל כאשר אתם משתמשים בכפתור **שוב** על כרטיס חזרה. ברירת
המחדל 0.00 פירושה שהמרווח של כרטיס חזרה מאופס לאפס כאשר אתם שוכחים אותו
(מה שהופך אז ליום אחד לאחר החלת [המרווח המינימלי](#מרווח מינימלי)).

אם משנים אותו מברירת המחדל, ייתכן שכרטיסים שנשכחו ישמרו על חלק
מהמרווח הקודם שלהם. לדוגמה, אם לכרטיס היה מרווח של 100 יום, והגדרתם
את **המרווח החדש** ל-0.20, המרווח החדש יהיה 20 יום.

בעוד ששימור חלק מהמרווח עשוי להיראות הגיוני, SuperMemo ציין
ששימור חלק מהמרווח יכול למעשה להיות מזיק. מסיבה זו, אנו ממליצים להשאיר אותו על הגדרת ברירת המחדל.

### תזמון מותאם אישית

למתקדמים- תוכלו לקבל יותר שליטה על תזמון הכרטיסים של אנקי על ידי שימוש ב-JavaScript משלכם בשדה התזמון המותאם אישית. זוהי אפשרות גלובלית, כך שקוד שיוזן כאן יחול על כל קבוצת הגדרות.
