// Populate the sidebar
//
// This is a script, and not included directly in the page, to control the total size of the book.
// The TOC contains an entry for each page, so if each page includes a copy of the TOC,
// the total size of the page becomes O(n**2).
class MDBookSidebarScrollbox extends HTMLElement {
    constructor() {
        super();
    }
    connectedCallback() {
        this.innerHTML = '<ol class="chapter"><li class="chapter-item affix "><a href="intro.html">מבוא</a></li><li class="chapter-item "><a href="background.html"><strong aria-hidden="true">1.</strong> רקע</a></li><li class="chapter-item "><a href="platform/intro.html"><strong aria-hidden="true">2.</strong> הערות לפי פלטפורמה</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="platform/windows/intro.html"><strong aria-hidden="true">2.1.</strong> Windows</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="platform/windows/installing.html"><strong aria-hidden="true">2.1.1.</strong> התקנה ושדרוג</a></li><li class="chapter-item "><a href="platform/windows/installation-issues.html"><strong aria-hidden="true">2.1.2.</strong> בעיות התקנה</a></li><li class="chapter-item "><a href="platform/windows/startup-issues.html"><strong aria-hidden="true">2.1.3.</strong> בעיות הפעלה</a></li><li class="chapter-item "><a href="platform/windows/display-issues.html"><strong aria-hidden="true">2.1.4.</strong> בעיות תצוגה</a></li><li class="chapter-item "><a href="platform/windows/copy-and-paste.html"><strong aria-hidden="true">2.1.5.</strong> בעיות העתקה והדבקה</a></li><li class="chapter-item "><a href="platform/windows/text-size.html"><strong aria-hidden="true">2.1.6.</strong> גודל טקסט</a></li><li class="chapter-item "><a href="platform/windows/permission-problems.html"><strong aria-hidden="true">2.1.7.</strong> בעיות הרשאה</a></li></ol></li></ol></li><li class="chapter-item "><a href="getting-started.html"><strong aria-hidden="true">3.</strong> תחילת העבודה</a></li><li class="chapter-item "><a href="getting-help.html"><strong aria-hidden="true">4.</strong> קבלת עזרה</a></li><li class="chapter-item "><a href="studying.html"><strong aria-hidden="true">5.</strong> למידה</a></li><li class="chapter-item "><a href="editing.html"><strong aria-hidden="true">6.</strong> הוספה/עריכה</a></li><li class="chapter-item "><a href="preferences.html"><strong aria-hidden="true">7.</strong> העדפות</a></li><li class="chapter-item "><a href="deck-options.html"><strong aria-hidden="true">8.</strong> אפשרויות חפיסה</a></li><li class="chapter-item "><a href="profiles.html"><strong aria-hidden="true">9.</strong> פרופילים</a></li><li class="chapter-item "><a href="browsing.html"><strong aria-hidden="true">10.</strong> דפדוף</a></li><li class="chapter-item "><a href="filtered-decks.html"><strong aria-hidden="true">11.</strong> חפיסות מסוננות</a></li><li class="chapter-item "><a href="searching.html"><strong aria-hidden="true">12.</strong> חיפוש</a></li><li class="chapter-item "><a href="importing/intro.html"><strong aria-hidden="true">13.</strong> ייבוא</a><a class="toggle"><div>❱</div></a></li><li><ol class="section"><li class="chapter-item "><a href="importing/text-files.html"><strong aria-hidden="true">13.1.</strong> קבצי טקסט</a></li><li class="chapter-item "><a href="importing/packaged-decks.html"><strong aria-hidden="true">13.2.</strong> חפיסות ארוזות</a></li></ol></li><li class="chapter-item "><a href="exporting.html"><strong aria-hidden="true">14.</strong> ייצוא</a></li><li class="chapter-item "><a href="backups.html"><strong aria-hidden="true">15.</strong> גיבויים</a></li><li class="chapter-item "><a href="files.html"><strong aria-hidden="true">16.</strong> ניהול קבצים</a></li><li class="chapter-item "><a href="stats.html"><strong aria-hidden="true">17.</strong> סטטיסטיקה</a></li><li class="chapter-item "><a href="media.html"><strong aria-hidden="true">18.</strong> מדיה</a></li><li class="chapter-item "><a href="leeches.html"><strong aria-hidden="true">19.</strong> עלוקות</a></li><li class="chapter-item "><a href="troubleshooting.html"><strong aria-hidden="true">20.</strong> פתרון בעיות</a></li><li class="chapter-item "><a href="syncing.html"><strong aria-hidden="true">21.</strong> סנכרון עם AnkiWeb</a></li><li class="chapter-item "><a href="misc.html"><strong aria-hidden="true">22.</strong> שונות</a></li><li class="chapter-item affix "><a href="contrib.html">תרומה</a></li><li class="chapter-item affix "><a href="faqs.html">שאלות נפוצות</a></li></ol>';
        // Set the current, active page, and reveal it if it's hidden
        let current_page = document.location.href.toString().split("#")[0].split("?")[0];
        if (current_page.endsWith("/")) {
            current_page += "index.html";
        }
        var links = Array.prototype.slice.call(this.querySelectorAll("a"));
        var l = links.length;
        for (var i = 0; i < l; ++i) {
            var link = links[i];
            var href = link.getAttribute("href");
            if (href && !href.startsWith("#") && !/^(?:[a-z+]+:)?\/\//.test(href)) {
                link.href = path_to_root + href;
            }
            // The "index" page is supposed to alias the first chapter in the book.
            if (link.href === current_page || (i === 0 && path_to_root === "" && current_page.endsWith("/index.html"))) {
                link.classList.add("active");
                var parent = link.parentElement;
                if (parent && parent.classList.contains("chapter-item")) {
                    parent.classList.add("expanded");
                }
                while (parent) {
                    if (parent.tagName === "LI" && parent.previousElementSibling) {
                        if (parent.previousElementSibling.classList.contains("chapter-item")) {
                            parent.previousElementSibling.classList.add("expanded");
                        }
                    }
                    parent = parent.parentElement;
                }
            }
        }
        // Track and set sidebar scroll position
        this.addEventListener('click', function(e) {
            if (e.target.tagName === 'A') {
                sessionStorage.setItem('sidebar-scroll', this.scrollTop);
            }
        }, { passive: true });
        var sidebarScrollTop = sessionStorage.getItem('sidebar-scroll');
        sessionStorage.removeItem('sidebar-scroll');
        if (sidebarScrollTop) {
            // preserve sidebar scroll position when navigating via links within sidebar
            this.scrollTop = sidebarScrollTop;
        } else {
            // scroll sidebar to current active section when navigating via "next/previous chapter" buttons
            var activeSection = document.querySelector('#sidebar .active');
            if (activeSection) {
                activeSection.scrollIntoView({ block: 'center' });
            }
        }
        // Toggle buttons
        var sidebarAnchorToggles = document.querySelectorAll('#sidebar a.toggle');
        function toggleSection(ev) {
            ev.currentTarget.parentElement.classList.toggle('expanded');
        }
        Array.from(sidebarAnchorToggles).forEach(function (el) {
            el.addEventListener('click', toggleSection);
        });
    }
}
window.customElements.define("mdbook-sidebar-scrollbox", MDBookSidebarScrollbox);
