# פתרון בעיית Authentication Failed

## הבעיה
אתה מקבל שגיאה: `Authentication failed: Error: OAuth2 request failed: Service responded with error: 'bad client id'`

## הסיבה
ה-Client ID ב-manifest.json לא תקין או לא הוחלף.

## הפתרון - צעד אחר צעד

### שלב 1: בדוק את manifest.json
פתח את הקובץ `manifest.json` וחפש את השורה:
\`\`\`json
"client_id": "..."
\`\`\`

אם כתוב שם `REPLACE_WITH_YOUR_GOOGLE_CLOUD_CLIENT_ID` - זה הבעיה!

### שלב 2: קבל Client ID אמיתי

#### 2.1 צור פרויקט ב-Google Cloud
1. לך ל: https://console.cloud.google.com/
2. לחץ על "Select a project" בחלק העליון
3. לחץ "NEW PROJECT"
4. שם הפרויקט: `OTP Extension`
5. לחץ "CREATE"
6. המתן עד שהפרויקט ייווצר (כמה שניות)

#### 2.2 הפעל Gmail API
1. בתפריט הצד: לחץ על "APIs & Services" ואז "Library"
2. בחיפוש הקלד: `Gmail API`
3. לחץ על "Gmail API"
4. לחץ "ENABLE"
5. המתן עד שה-API יופעל

#### 2.3 הגדר OAuth Consent Screen (חובה!)
1. בתפריט הצד: "APIs & Services" > "OAuth consent screen"
2. בחר "External"
3. לחץ "CREATE"
4. מלא את הפרטים:
   - **App name**: `OTP AutoFill`
   - **User support email**: בחר את המייל שלך
   - **Developer contact information**: הזן את המייל שלך
5. לחץ "SAVE AND CONTINUE"
6. בעמוד Scopes: לחץ "ADD OR REMOVE SCOPES"
7. חפש וסמן: `https://www.googleapis.com/auth/gmail.readonly`
8. לחץ "UPDATE"
9. לחץ "SAVE AND CONTINUE"
10. בעמוד Test users: לחץ "ADD USERS"
11. הוסף את המייל שלך
12. לחץ "SAVE AND CONTINUE"
13. לחץ "BACK TO DASHBOARD"

#### 2.4 צור OAuth Client ID
1. בתפריט הצד: "APIs & Services" > "Credentials"
2. לחץ "+ CREATE CREDENTIALS"
3. בחר "OAuth client ID"
4. ב-"Application type" בחר: **"Chrome app"**
   - אם אין אפשרות כזו, בחר "Web application"
5. שם: `OTP Extension Client`
6. לחץ "CREATE"
7. **העתק את ה-Client ID!**
   - זה ייראה כמו: `123456789-abcdefg.apps.googleusercontent.com`
   - שמור אותו במקום בטוח

### שלב 3: החלף ב-manifest.json

1. פתח את `manifest.json`
2. מצא את השורה:
\`\`\`json
"client_id": "REPLACE_WITH_YOUR_GOOGLE_CLOUD_CLIENT_ID.apps.googleusercontent.com"
\`\`\`
3. החלף את כל הטקסט עם ה-Client ID שהעתקת
4. לדוגמה:
\`\`\`json
"client_id": "123456789-abcdefg.apps.googleusercontent.com"
\`\`\`
5. **שמור את הקובץ!**

### שלב 4: טען מחדש את התוסף (חובה!)

1. פתח Chrome ולך ל: `chrome://extensions/`
2. מצא את התוסף "OTP Auto-Fill from Gmail"
3. לחץ על כפתור 🔄 (Reload) ליד התוסף
4. בדוק שאין שגיאות אדומות

### שלב 5: נסה להתחבר

1. לחץ על אייקון התוסף בסרגל הכלים
2. לחץ "Connect Gmail"
3. אם מופיע "This app isn't verified":
   - לחץ "Advanced"
   - לחץ "Go to OTP AutoFill (unsafe)"
   - זה בטוח כי זה התוסף שלך!
4. אשר את ההרשאות

## אם עדיין לא עובד

### בדיקה 1: Client ID נכון?
ב-manifest.json, ה-Client ID חייב להסתיים ב-`.apps.googleusercontent.com`

### בדיקה 2: OAuth Consent Screen הוגדר?
חזור ל-Google Cloud Console ובדוק ש-OAuth consent screen מוגדר עם Scopes.

### בדיקה 3: טענת מחדש את התוסף?
אחרי כל שינוי ב-manifest.json חובה ללחוץ על 🔄 Reload!

### בדיקה 4: בדוק שגיאות
ב-`chrome://extensions/` לחץ על "Errors" ליד התוסף ובדוק מה כתוב.

## עזרה נוספת

אם אתה רואה שגיאה ספציפית, העתק את כל טקסט השגיאה ושלח לי.
