# הוראות סופיות להפעלת התוסף

## מה תיקנתי:
✅ הסרתי את כל ההצהרות המיותרות של `const chrome = window.chrome`
✅ התוסף עכשיו אמור לטעון ללא שגיאות

## מה אתה צריך לעשות:

### 1. טען מחדש את התוסף ב-Chrome
- לך ל: `chrome://extensions/`
- מצא את התוסף "OTP Auto-Fill from Gmail"
- לחץ על כפתור 🔄 (Reload)

### 2. החלף את ה-Client ID
הקובץ `manifest.json` עדיין מכיל:
\`\`\`json
"client_id": "REPLACE_WITH_YOUR_GOOGLE_CLOUD_CLIENT_ID.apps.googleusercontent.com"
\`\`\`

**אתה חייב להחליף את זה ב-Client ID האמיתי שלך מ-Google Cloud Console.**

### איך לקבל Client ID:

1. **לך ל-Google Cloud Console:**
   https://console.cloud.google.com/

2. **צור פרויקט חדש:**
   - לחץ "Select a project" → "NEW PROJECT"
   - שם: "OTP Extension"
   - לחץ "CREATE"

3. **הפעל Gmail API:**
   - תפריט צד: "APIs & Services" → "Library"
   - חפש "Gmail API"
   - לחץ "ENABLE"

4. **הגדר OAuth Consent Screen (חובה!):**
   - תפריט צד: "APIs & Services" → "OAuth consent screen"
   - בחר "External" → "CREATE"
   - מלא:
     - App name: "OTP Extension"
     - User support email: המייל שלך
     - Developer contact: המייל שלך
   - לחץ "SAVE AND CONTINUE" 3 פעמים

5. **צור Client ID:**
   - תפריט צד: "APIs & Services" → "Credentials"
   - לחץ "+ CREATE CREDENTIALS" → "OAuth client ID"
   - Application type: **"Chrome app"**
   - Name: "OTP Extension"
   - Application ID: השאר ריק
   - לחץ "CREATE"
   - **העתק את ה-Client ID!**

6. **החלף ב-manifest.json:**
   - פתח את `manifest.json`
   - החלף את `REPLACE_WITH_YOUR_GOOGLE_CLOUD_CLIENT_ID.apps.googleusercontent.com`
   - עם ה-Client ID שהעתקת
   - שמור את הקובץ

7. **טען מחדש את התוסף:**
   - חזור ל-`chrome://extensions/`
   - לחץ 🔄 ליד התוסף

### 3. בדוק שזה עובד
- לחץ על אייקון התוסף
- לחץ "Connect Gmail"
- אשר את ההרשאות
- אם הכל תקין, תראה "Connected to Gmail"

## שגיאות נפוצות:

**"bad client id"** = לא החלפת את ה-Client ID או שהוא לא נכון

**"This app isn't verified"** = זה נורמלי! לחץ "Advanced" → "Go to [App Name] (unsafe)"

**"Access blocked"** = לא הגדרת OAuth consent screen - חזור לשלב 4

---

אם עדיין יש בעיות, שלח לי את השגיאה המדויקת שאתה רואה.
