// Content script that runs on all pages

console.log("[v0] OTP Auto-Fill content script loaded")

// Declare the chrome variable
const chrome = window.chrome

// Listen for messages from background script
chrome.runtime.onMessage.addListener((message, sender, sendResponse) => {
  if (message.action === "fillOTP") {
    fillOTPCode(message.code)
  }
})

function fillOTPCode(code) {
  console.log("[v0] Attempting to fill OTP code:", code)

  // Find potential OTP input fields
  const inputs = document.querySelectorAll(
    'input[type="text"], input[type="password"], input[type="tel"], input[type="number"]',
  )

  for (const input of inputs) {
    const name = (input.name || "").toLowerCase()
    const id = (input.id || "").toLowerCase()
    const placeholder = (input.placeholder || "").toLowerCase()
    const ariaLabel = (input.getAttribute("aria-label") || "").toLowerCase()

    // Hebrew and English keywords for OTP fields
    const otpKeywords = ["otp", "code", "verification", "verify", "קוד", "אימות", "סיסמה", "password", "pin"]

    const isOtpField = otpKeywords.some(
      (keyword) =>
        name.includes(keyword) || id.includes(keyword) || placeholder.includes(keyword) || ariaLabel.includes(keyword),
    )

    if (isOtpField && !input.value) {
      // Fill the input
      input.value = code

      // Trigger events to ensure the value is recognized
      input.dispatchEvent(new Event("input", { bubbles: true }))
      input.dispatchEvent(new Event("change", { bubbles: true }))
      input.dispatchEvent(new Event("blur", { bubbles: true }))

      // Focus the input
      input.focus()

      console.log("[v0] OTP code filled successfully in:", input)

      // Show visual feedback
      input.style.transition = "background-color 0.3s"
      input.style.backgroundColor = "#d4edda"
      setTimeout(() => {
        input.style.backgroundColor = ""
      }, 2000)

      break
    }
  }
}

// Watch for dynamically added OTP fields
const observer = new MutationObserver((mutations) => {
  // Check if there's a recent OTP code to fill
  chrome.storage.local.get(["lastOtpCode", "lastOtpTimestamp", "lastOtpRule"], (result) => {
    if (result.lastOtpCode && result.lastOtpTimestamp) {
      // Only use codes from the last 2 minutes
      const age = Date.now() - result.lastOtpTimestamp
      if (age < 120000 && result.lastOtpRule) {
        // Check if current page matches the rule
        const currentUrl = window.location.href
        const ruleUrl = new URL(result.lastOtpRule.websiteUrl)

        if (currentUrl.includes(ruleUrl.hostname)) {
          fillOTPCode(result.lastOtpCode)
        }
      }
    }
  })
})

observer.observe(document.body, {
  childList: true,
  subtree: true,
})
