# הוראות התקנה - OTP Auto-Fill Extension

## שלב 1: הגדרת Google Cloud Console

### 1.1 יצירת פרויקט
1. גש ל-https://console.cloud.google.com/
2. לחץ על "New Project" וצור פרויקט בשם "OTP AutoFill"

### 1.2 הפעלת Gmail API
1. לך ל-"APIs & Services" > "Library"
2. חפש "Gmail API" והפעל אותו

### 1.3 הגדרת OAuth Consent Screen
1. לך ל-"APIs & Services" > "OAuth consent screen"
2. בחר "External" ולחץ "Create"
3. מלא:
   - App name: "OTP AutoFill"
   - User support email: המייל שלך
   - Developer contact: המייל שלך
4. לחץ "Save and Continue"
5. ב-Scopes, הוסף: `https://www.googleapis.com/auth/gmail.readonly`
6. ב-Test users, הוסף את המייל שלך
7. לחץ "Save and Continue" עד הסוף

### 1.4 יצירת OAuth Client ID
1. לך ל-"APIs & Services" > "Credentials"
2. לחץ "+ Create Credentials" > "OAuth client ID"
3. בחר "Chrome extension" או "Web application"
4. תן שם: "OTP AutoFill Client"
5. לחץ "Create"
6. **העתק את ה-Client ID** (נראה כך: `123456789-abc...xyz.apps.googleusercontent.com`)

## שלב 2: עדכון התוסף

1. פתח את קובץ `manifest.json`
2. מצא את השורה:
   \`\`\`json
   "client_id": "REPLACE_WITH_YOUR_GOOGLE_CLOUD_CLIENT_ID.apps.googleusercontent.com"
   \`\`\`
3. החלף את הטקסט עם ה-Client ID שהעתקת
4. שמור את הקובץ

## שלב 3: טעינת התוסף ל-Chrome

1. פתח Chrome ולך ל-`chrome://extensions/`
2. הפעל "Developer mode" בפינה הימנית העליונה
3. לחץ "Load unpacked"
4. בחר את התיקייה של התוסף
5. התוסף אמור להופיע ברשימה ללא שגיאות

## שלב 4: שימוש בתוסף

1. לחץ על אייקון התוסף בסרגל הכלים
2. לחץ "Connect Gmail"
3. התחבר לחשבון Google שלך
4. אשר את ההרשאות
5. לחץ על "Settings" כדי להוסיף כללים:
   - כתובת האתר (לדוגמה: https://www.hist.org.il/)
   - כתובת המייל השולח (לדוגמה: DoNotReply@swish.co.il)
   - תבנית הקוד (ברירת מחדל: 6 ספרות)

## פתרון בעיות

### "Access blocked: This app's request is invalid"
- לא הגדרת OAuth consent screen - חזור לשלב 1.3

### "The OAuth client was not found"
- ה-Client ID לא נכון - בדוק שהעתקת נכון בשלב 1.4

### "This app isn't verified"
- זה נורמלי לאפליקציות בפיתוח
- לחץ "Advanced" ואז "Go to [App Name] (unsafe)"

### התוסף לא מופיע
- בדוק שכל הקבצים בתיקייה אחת
- בדוק שאין שגיאות ב-manifest.json
- בדוק ב-`chrome://extensions/` אם יש שגיאות
