/*
 * Decompiled with CFR 0.152.
 */
package com.souramoo.unapkm;

import com.goterl.lazycode.lazysodium.LazySodiumJava;
import com.goterl.lazycode.lazysodium.SodiumJava;
import com.goterl.lazycode.lazysodium.interfaces.PwHash;
import com.goterl.lazycode.lazysodium.interfaces.SecretStream;
import com.sun.jna.NativeLong;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class UnApkm {
    private static final String HEXES = "0123456789ABCDEF";
    public static final long MEM_LIMIT = 0x20000000L;

    private UnApkm() {
    }

    private static byte[] getBytes(InputStream i, int num) throws IOException {
        byte[] data = new byte[num];
        i.read(data, 0, data.length);
        return data;
    }

    private static int byteToInt(byte[] b) {
        int result = 0;
        int shift = 0;
        for (int i = 0; i < b.length; ++i) {
            byte be = b[i];
            result |= (be & 0xFF) << shift;
            shift += 8;
        }
        return result;
    }

    public static String getHex(byte[] raw) {
        int max = Math.min(100, raw.length);
        StringBuilder hex = new StringBuilder(2 * max);
        for (int i = 0; i < max; ++i) {
            byte b = raw[i];
            hex.append(HEXES.charAt((b & 0xF0) >> 4)).append(HEXES.charAt(b & 0xF));
        }
        return hex.toString();
    }

    public static Header processHeader(InputStream i, LazySodiumJava lazySodium) throws IOException {
        return UnApkm.processHeader(i, lazySodium, true);
    }

    public static Header processHeader(InputStream i, LazySodiumJava lazySodium, boolean expensiveOps) throws IOException {
        return UnApkm.processHeader(i, lazySodium, expensiveOps, 0x20000000L);
    }

    public static Header processHeader(InputStream i, LazySodiumJava lazySodium, boolean expensiveOps, long upperMemLimit) throws IOException {
        UnApkm.getBytes(i, 1);
        byte alg = UnApkm.getBytes(i, 1)[0];
        if (alg > 2 || alg < 1) {
            throw new IOException("incorrect algo");
        }
        PwHash.Alg algo = PwHash.Alg.valueOf(alg);
        long opsLimit = UnApkm.byteToInt(UnApkm.getBytes(i, 8));
        int memLimit = UnApkm.byteToInt(UnApkm.getBytes(i, 8));
        if (memLimit < 0 || (long)memLimit > upperMemLimit) {
            throw new IOException("too much memory aaah");
        }
        byte[] en = UnApkm.getBytes(i, 8);
        long chunkSize = UnApkm.byteToInt(en);
        byte[] salt = UnApkm.getBytes(i, 16);
        byte[] pwHashBytes = UnApkm.getBytes(i, 24);
        byte[] outputHash = new byte[32];
        if (expensiveOps) {
            lazySodium.cryptoPwHash(outputHash, 32, "#$%@#dfas4d00fFSDF9GSD56$^53$%7WRGF3dzzqasD!@".getBytes(), 45, salt, opsLimit, new NativeLong((long)memLimit), algo);
        }
        return new Header(pwHashBytes, outputHash, chunkSize);
    }

    public static InputStream decryptStream(InputStream i) throws IOException {
        LazySodiumJava lazySodium = new LazySodiumJava(new SodiumJava());
        Header h = UnApkm.processHeader(i, lazySodium);
        return UnApkm.decryptStream(i, h, lazySodium);
    }

    public static InputStream decryptStream(InputStream i, Header h) throws IOException {
        LazySodiumJava lazySodium = new LazySodiumJava(new SodiumJava());
        UnApkm.processHeader(i, lazySodium, false);
        return UnApkm.decryptStream(i, h, lazySodium);
    }

    public static InputStream decryptStream(final InputStream i, final Header h, final LazySodiumJava lazySodium) throws IOException {
        PipedInputStream pipedInputStream = new PipedInputStream();
        final PipedOutputStream pipedOutputStream = new PipedOutputStream();
        pipedInputStream.connect(pipedOutputStream);
        Thread pipeWriter = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    SecretStream.State state = new SecretStream.State();
                    lazySodium.cryptoSecretStreamInitPull(state, h.pwHashBytes, h.outputHash);
                    long chunkSizePlusPadding = h.chunkSize + 17L;
                    byte[] cipherChunk = new byte[(int)chunkSizePlusPadding];
                    int bytesRead = 0;
                    while ((bytesRead = i.read(cipherChunk)) != -1) {
                        byte[] decryptedChunk = new byte[(int)h.chunkSize];
                        int tagSize = 1;
                        byte[] tag = new byte[tagSize];
                        boolean success = lazySodium.cryptoSecretStreamPull(state, decryptedChunk, tag, cipherChunk, bytesRead);
                        if (!success) {
                            throw new IOException("decrypto error");
                        }
                        pipedOutputStream.write(decryptedChunk);
                        Arrays.fill(cipherChunk, (byte)0);
                    }
                }
                catch (IOException e) {
                    if (!e.getMessage().equals("Pipe closed")) {
                        e.printStackTrace();
                    }
                }
                finally {
                    try {
                        pipedOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        };
        pipeWriter.start();
        return pipedInputStream;
    }

    public static void decryptFile(String inFile, String outFile) {
        try {
            FileInputStream is = new FileInputStream(inFile);
            InputStream toOut = UnApkm.decryptStream(is);
            ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(outFile)));
            ZipInputStream zipIn = new ZipInputStream(toOut);
            ZipEntry entry = zipIn.getNextEntry();
            while (entry != null) {
                int read;
                zos.putNextEntry(new ZipEntry(entry.getName()));
                byte[] bytesIn = new byte[4096];
                while ((read = zipIn.read(bytesIn)) != -1) {
                    zos.write(bytesIn, 0, read);
                }
                zos.closeEntry();
                zipIn.closeEntry();
                entry = zipIn.getNextEntry();
            }
            zipIn.close();
            zos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static boolean isAlreadyZip(File f) {
        int fileSignature = 0;
        try {
            RandomAccessFile raf = new RandomAccessFile(f, "r");
            fileSignature = raf.readInt();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return fileSignature == 1347093252 || fileSignature == 1347093766 || fileSignature == 1347094280;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: java -jar unapkm.jar <input .apkm file> <output.apks file>\n\nDefault output file is <input file>.apks\n\nenjoy!!!");
            return;
        }
        String in = args[0];
        String out = in + ".apks";
        if (args.length > 1) {
            out = args[1];
        }
        if (UnApkm.isAlreadyZip(new File(in))) {
            System.out.println("The file at " + in + " appears to already be a regular ZIP file :)\n\nYou can just rename this to .apks and install with SAI or similar, no decryption with this tool is required.");
        } else {
            UnApkm.decryptFile(in, out);
        }
    }

    static class Header {
        byte[] pwHashBytes;
        byte[] outputHash;
        long chunkSize;

        Header(byte[] pwHashBytes, byte[] outputHash, long chunkSize) {
            this.pwHashBytes = pwHashBytes;
            this.outputHash = outputHash;
            this.chunkSize = chunkSize;
        }
    }
}

