@echo off

SET SPRD_LTE_ENUM_INF_NAME="%CD%\drivers\sprdlte_9610_enum.inf"
SET LTE_NDIS_INF_FILE_NAME="%CD%\drivers\sprdlte_9610_usbnet.inf"
set USB_MODEM_INF_FILE_NAME="%CD%\drivers\sprdlte_9610_usbmodem.inf"
set USB_PORT_INF_FILE_NAME="%CD%\drivers\sprdlte_9610_usbport.inf"

set NDIS_DEVICE_LIST="DCUSB\VID_1782&PID_000A&MI_02"
set USB_ENUM_DEVICE_LIST="USB\VID_1782&PID_000A&MI_02" 
set USB_MODEM_DEVICE_LIST="USB\VID_1782&PID_0005&MI_01" "USB\VID_1782&PID_0007&MI_01"
set USB_PORT_DEVICE_LIST="USB\VID_1782&PID_000A&MI_00" "USB\VID_1782&PID_000A&MI_01" 

SET DEVCON="%CD%\devcon"
set SLEEP="%CD%\sleep"

goto START

:RESCAN
%DEVCON% rescan
GOTO:EOF

:INSTALL_DEVICE
%DEVCON% install %1 %2
GOTO:EOF

:UPDATE_DRIVER
%DEVCON% update %1 %2
GOTO:EOF

:REMOVE_DEVICE
%DEVCON% remove %1
GOTO:EOF

:ENABLE_DEVICE
%DEVCON% enable %1
GOTO:EOF

:START

echo starting to install SPRD LTE 9610 device drivers ...

echo installing root bus device ...
CALL :UPDATE_DRIVER %SPRD_LTE_ENUM_INF_NAME% "SPRDLTE_9610_ENUMROOT"
IF ERRORLEVEL 1 (
	CALL :REMOVE_DEVICE "SPRD_LTE_ENUMROOT"
	CALL :INSTALL_DEVICE %SPRD_LTE_ENUM_INF_NAME% "SPRDLTE_9610_ENUMROOT"
)
%SLEEP% 2

echo installing usb modem device ...
FOR %%A IN (%USB_MODEM_DEVICE_LIST%) DO (
	CALL :UPDATE_DRIVER %USB_MODEM_INF_FILE_NAME% %%A
)

echo installing usb port device ...
FOR %%A IN (%USB_PORT_DEVICE_LIST%) DO (
	CALL :UPDATE_DRIVER %USB_PORT_INF_FILE_NAME% %%A
)

echo installing usb enumerator device ...
CALL :RESCAN
FOR %%A IN (%USB_ENUM_DEVICE_LIST%) DO (
	CALL :UPDATE_DRIVER %SPRD_LTE_ENUM_INF_NAME% %%A
	CALL :ENABLE_DEVICE %%A
)

echo sleep a while to wait for ndis device enumeration ...
%SLEEP% 5

echo installing lte ndis device ...
FOR %%A IN (%NDIS_DEVICE_LIST%) DO (
	CALL :UPDATE_DRIVER %LTE_NDIS_INF_FILE_NAME% %%A
)


:END
echo finished!

