#!/system/bin-sh
#
# --- Comprehensive VoLTE & IMS Enabler Script for MTK Devices (v4) ---
#
# This script uses a systemless approach to enable VoLTE.
# IT DOES NOT MODIFY THE /system PARTITION.
#
# 1. Sets persistent system properties for VoLTE/VoWiFi.
# 2. Dynamically gets the current carrier's information.
# 3. Checks if an IMS APN already exists in the live database.
# 4. If missing, inserts the IMS APN directly using the Content Provider.
# 5. Sends AT commands to the modem to enable VoLTE.
# 6. Conditionally applies the SGS SMS fix ONLY for the Cellcom network.
#
# Must be run as root.
#
sleep 30
 
echo "--- Comprehensive VoLTE & IMS Enabler (v4 - Systemless) ---"
echo ""
 
# --- 0. PRE-FLIGHT CHECK ---
if [ "$(id -u)" -ne 0 ]; then
  echo "[ERROR] This script must be run as root. Please run 'su' first."
  exit 1
fi
 
# --- 1. SETTING SYSTEM PROPERTIES ---
echo "[STEP 1] Setting persistent system properties for VoLTE/VoWiFi..."
setprop persist.vendor.mtk.volte.enable 1
setprop persist.vendor.radio.volte_state 1
setprop persist.vendor.mtk.wfc.enable 1
setprop persist.dbg.volte_avail_ovr 1
setprop persist.vendor.radio.selfreg 1
setprop persist.vendor.service.atci.pct.mode 1
setprop persist.vendor.mtk_dynamic_ims_switch 0
echo "--> System properties set successfully."
echo ""
 
# --- 2. DYNAMICALLY ADDING IMS APN VIA CONTENT PROVIDER ---
echo "[STEP 2] Checking and adding IMS APN to live database..."
# Get the MCC/MNC from the active SIM card
OPERATOR_NUMERIC=$(getprop gsm.sim.operator.numeric)
 
if [ -z "$OPERATOR_NUMERIC" ]; then
    echo "[WARNING] Could not detect SIM operator. Skipping APN insertion."
else
    MCC=${OPERATOR_NUMERIC:0:3}
    MNC=${OPERATOR_NUMERIC:3}
    echo "[INFO] Detected Operator: MCC=$MCC, MNC=$MNC"
 
    # Check if an IMS APN already exists for this operator to avoid duplicates
    IMS_EXISTS=$(content query --uri content://telephony/carriers --where "numeric = '$OPERATOR_NUMERIC' AND type LIKE '%ims%'" | grep -c "Row:")
 
    if [ "$IMS_EXISTS" -gt 0 ]; then
        echo "--> IMS APN already exists for this operator. No action needed."
    else
        echo "--> IMS APN not found. Inserting into database..."
        content insert --uri content://telephony/carriers \
            --bind name:s:ims \
            --bind apn:s:ims \
            --bind mcc:s:$MCC \
            --bind mnc:s:$MNC \
            --bind numeric:s:$OPERATOR_NUMERIC \
            --bind type:s:ims \
            --bind protocol:s:IPV4V6 \
            --bind roaming_protocol:s:IPV4V6 \
            --bind carrier_enabled:i:1 >/dev/null 2>&1
        echo "--> IMS APN has been added successfully."
    fi
fi
echo ""
 
# --- 3. TRIGGERING THE MODEM WITH AT COMMANDS ---
echo "[STEP 3] Finding modem and sending AT command sequence..."
PID=$(pidof mtkfusionrild)
if [ -z "$PID" ]; then
    echo "[ERROR] Could not find mtkfusionrild process. Skipping AT commands."
else
    TTY_LIST=$(lsof -p "$PID" | grep /dev/pts | awk '{print $NF}' | sort -u)
    RESPONSIVE_TTY=""
    for TTY in $TTY_LIST; do
      echo -e "AT\\r" > "$TTY"
      sleep 0.3
      if [ -n "$(timeout 1 cat "$TTY" | grep OK)" ]; then
        RESPONSIVE_TTY=$TTY
        break
      fi
    done
 
    if [ -z "$RESPONSIVE_TTY" ]; then
        echo "[FAILURE] Could not find a responsive AT command TTY port."
    else
        echo "[SUCCESS] Found responsive TTY at: $RESPONSIVE_TTY"
        echo "[INFO] Sending VoLTE trigger and conditional SMS Fix..."
        #Turns off the MNCMCC Check
	echo -e "AT+ECFGSET=\"mncmcc_pass_flag\",\"0\"\\r" > "$RESPONSIVE_TTY"
        sleep 0.5
	# The confirmed Trigger Command
        echo -e "AT+ECFGSET=\"operator_code\",\"232\"\\r" > "$RESPONSIVE_TTY"
        sleep 0.5
        
        # Conditional SGS Command for SMS compatibility ONLY on Cellcom (MNC 02)
        if [ "$MNC" = "02" ]; then
            echo "[INFO] Cellcom network detected. Applying SGS SMS Fix..."
            echo -e "AT+ECFGSET=\"sdm_profile_prefer_sms_over_sgs_to_ims\",\"1\"\\r" > "$RESPONSIVE_TTY"
            sleep 0.5
        fi        
	# The "Apply" Command to save all settings
        echo -e "AT+EIMSCFG=1,0,0,0,1,1\\r" > "$RESPONSIVE_TTY"
        sleep 0.5
 
        # Clear the buffer
        timeout 1 cat "$RESPONSIVE_TTY" > /dev/null
        echo "--> VoLTE AT command sequence sent successfully."
	echo "Turning On Volte Calls In The Settings.."
	settings put global volte_vt_enabled 1
    fi
fi
echo ""
 
# --- 4. FINAL INSTRUCTIONS ---
echo "--- SCRIPT FINISHED ---"
echo "All VoLTE enablement steps have been completed."
echo "The VoLTE icon should appear shortly. For changes to take full effect, a REBOOT is still recommended."
echo "-----------------------"
rm /data/adb/service.d/volte-install.sh 
 
