(function () {
  // פונקציה שמוחקת אלמנטים לפי טקסט
  function deepRemove(node) {
    if (!node) return;
    const walker = document.createTreeWalker(node, NodeFilter.SHOW_ELEMENT, null, false);

    while (walker.nextNode()) {
      const el = walker.currentNode;
      const text = el.innerText || "";
      if (
        (text.includes("נוסעים ב") && text.includes("Moovit")) ||
        text.includes("הירשמו עכשיו") ||
        text.includes("משלמים באפליקציה")
      ) {
        if (el.offsetHeight < window.innerHeight / 2) {
          el.remove();
        }
      }

      // כניסה ל־Shadow DOM (אם קיים)
      if (el.shadowRoot) {
        deepRemove(el.shadowRoot);
      }
    }
  }

  // ניסיון מחיקה מחזורי
  function cleanLoop() {
    deepRemove(document);
  }

  // ניסיון ראשון אחרי טעינה
  window.addEventListener('load', () => {
    // הסתרת באנרים רגילים
    const style = document.createElement('style');
    style.textContent = `
      mv-ad-wrapper.additional-ad-banner,
      mv-qr-code-banner {
        display: none !important;
      }
    `;
    document.head.appendChild(style);

    cleanLoop();

    // ניסיון חוזר כל 2 שניות למשך 15 שניות
    let counter = 0;
    const interval = setInterval(() => {
      cleanLoop();
      counter += 1;
      if (counter > 7) clearInterval(interval);
    }, 2000);

    // השגחה על שינויים דינמיים
    const observer = new MutationObserver(() => cleanLoop());
    observer.observe(document.body, { childList: true, subtree: true });
  });
})();
