using Microsoft.Win32;
using System;
using System.Windows;

namespace NokiaIBConverterApp
{
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
        }

        private void BtnSelectVcf_Click(object sender, RoutedEventArgs e)
        {
            var dlg = new OpenFileDialog { Filter = "VCF files|*.vcf|All files|*.*" };
            if (dlg.ShowDialog() == true) TxtVcfPath.Text = dlg.FileName;
        }

        private void BtnSelectOut_Click(object sender, RoutedEventArgs e)
        {
            var dlg = new SaveFileDialog { Filter = "IB files|*.ib|All files|*.*", FileName = "contacts.ib" };
            if (dlg.ShowDialog() == true) TxtOutPath.Text = dlg.FileName;
        }

        private void BtnConvert_Click(object sender, RoutedEventArgs e)
        {
            try
            {
                if (string.IsNullOrEmpty(TxtVcfPath.Text) || string.IsNullOrEmpty(TxtOutPath.Text))
                {
                    MessageBox.Show("בחר קובץ VCF וקובץ יעד.", "שגיאה", MessageBoxButton.OK, MessageBoxImage.Error);
                    return;
                }

                var reader = new NokiaIBConverter.VcfReader();
                var contacts = reader.Read(TxtVcfPath.Text);

                using (var writer = new NokiaIBConverter.IbWriter(TxtOutPath.Text))
                {
                    foreach (var c in contacts)
                    {
                        writer.Write(c);
                    }
                }

                MessageBox.Show("המרה ל-IB הושלמה (best-effort).", "סיום", MessageBoxButton.OK, MessageBoxImage.Information);
            }
            catch (Exception ex)
            {
                MessageBox.Show("שגיאה: " + ex.Message, "שגיאה", MessageBoxButton.OK, MessageBoxImage.Error);
            }
        }
    }
}
