using System;
using System.Collections.Generic;
using System.IO;
using System.Text.RegularExpressions;

namespace NokiaIBConverter
{
    // Simple VCF reader returning ContactEntry instances.
    public class VcfReader
    {
        public List<ContactEntry> Read(string path)
        {
            var all = File.ReadAllText(path);
            var contacts = new List<ContactEntry>();
            var cards = Regex.Split(all, "END:VCARD", RegexOptions.IgnoreCase);
            foreach (var c in cards)
            {
                if (string.IsNullOrWhiteSpace(c)) continue;
                var nameMatch = Regex.Match(c, "N:(.*?)\r?\n", RegexOptions.IgnoreCase);
                var fnMatch = Regex.Match(c, "FN:(.*?)\r?\n", RegexOptions.IgnoreCase);
                var telMatches = Regex.Matches(c, "TEL.*?:(.*?)\r?\n", RegexOptions.IgnoreCase);

                var entry = new ContactEntry();
                if (nameMatch.Success)
                {
                    var parts = nameMatch.Groups[1].Value.Split(';');
                    entry.LastName = parts.Length>0?parts[0].Trim():"";
                    entry.FirstName = parts.Length>1?parts[1].Trim():"";
                }
                else if (fnMatch.Success)
                {
                    var parts = fnMatch.Groups[1].Value.Split(' ');
                    entry.FirstName = parts.Length>0?parts[0].Trim():"";
                    entry.LastName = parts.Length>1?parts[1].Trim():"";
                }

                var phones = new List<string>();
                foreach (System.Text.RegularExpressions.Match m in telMatches)
                {
                    phones.Add(m.Groups[1].Value.Trim());
                }

                entry.PhoneNumber = phones.Count>0? new string[]{ phones[0] } : null;
                // for compatibility with original structure, fill PhoneNumber2/3 if available
                if (phones.Count>1) entry.PhoneNumber2 = new string[]{ phones[1] };
                if (phones.Count>2) entry.PhoneNumber3 = new string[]{ phones[2] };

                if ((entry.PhoneNumber?.Length ?? 0) > 0)
                    contacts.Add(entry);
            }
            return contacts;
        }
    }
}
