package com.yossi.kosherappstore

import android.app.Activity
import android.content.ActivityNotFoundException
import android.content.Context
import android.content.Intent
//import android.content.SharedPreferences // הוסר
import android.net.Uri
import android.os.Bundle
import android.provider.OpenableColumns
import android.text.TextUtils
import android.util.Log
import android.view.LayoutInflater
import android.widget.Button
import android.widget.EditText
import android.widget.RadioButton
import android.widget.RadioGroup
import android.widget.TextView
import android.widget.Toast
import androidx.activity.result.ActivityResultLauncher
import androidx.activity.result.contract.ActivityResultContracts
import androidx.appcompat.app.AlertDialog
import androidx.appcompat.app.AppCompatActivity
import androidx.core.content.FileProvider
//import androidx.core.content.edit // הוסר
import com.google.android.material.switchmaterial.SwitchMaterial
import com.google.gson.Gson
import com.google.gson.reflect.TypeToken
import kotlinx.coroutines.*
import java.io.*
import java.lang.reflect.Type
import java.util.UUID
import java.util.zip.ZipEntry
import java.util.zip.ZipInputStream
import java.util.zip.ZipOutputStream

// Importים לקבועים מ-MainActivity
import com.yossi.kosherappstore.MainActivity.Companion.PREFS_NAME
import com.yossi.kosherappstore.MainActivity.Companion.KEY_APPS_LIST
import com.yossi.kosherappstore.MainActivity.Companion.KEY_SETTINGS_PASSWORD
import com.yossi.kosherappstore.MainActivity.Companion.DEFAULT_PASSWORD
import com.yossi.kosherappstore.MainActivity.Companion.KEY_INSTALL_LOCATION
import com.yossi.kosherappstore.MainActivity.Companion.KEY_USE_ROOT_INSTALL
import com.yossi.kosherappstore.MainActivity.Companion.KEY_NORMAL_INSTALL_MODE
import com.yossi.kosherappstore.MainActivity.Companion.KEY_ROOT_INSTALL_METHOD
import com.yossi.kosherappstore.MainActivity.Companion.ROOT_METHOD_PM_INSTALL
import com.yossi.kosherappstore.MainActivity.Companion.ROOT_METHOD_COPY_TO_SYSTEM
import com.yossi.kosherappstore.MainActivity.Companion.KEY_ENABLE_SEND_FEEDBACK
import com.yossi.kosherappstore.MainActivity.Companion.KEY_ABOUT_TEXT
import com.yossi.kosherappstore.MainActivity.Companion.DEFAULT_ABOUT_TEXT
import com.yossi.kosherappstore.MainActivity.Companion.KEY_USE_CUSTOM_STORAGE_PATH
import com.yossi.kosherappstore.MainActivity.Companion.KEY_CUSTOM_STORAGE_PATH
import com.yossi.kosherappstore.MainActivity.Companion.KOSHER_STORE_BASE_DIR_SYSTEM
import com.yossi.kosherappstore.MainActivity.Companion.CONFIG_FILE_NAME
import com.yossi.kosherappstore.MainActivity.Companion.APPS_SUBDIR_NAME_IN_CONFIG_PATH
import com.yossi.kosherappstore.MainActivity.Companion.DEFAULT_SYSTEM_STORAGE_PATH_FOR_APPS


class SettingsActivity : AppCompatActivity() {

    companion object {
        private const val TAG = "SettingsActivity"
        private const val LOCKED_APK_ASSET_NAME = "kosher_app_store_locked.apk"
        private const val MANIFEST_FILE_NAME = "store_manifest.json"
        private const val APKS_DIR_NAME = "apks"
        private const val IMAGES_DIR_NAME = "images"
    }

    private var editTextDialogAppName: EditText? = null
    private var editTextDialogAppDescription: EditText? = null
    private var editTextDialogAppPackageName: EditText? = null
    private var currentApkUri: Uri? = null
    private var currentImageUri: Uri? = null

    // private lateinit var sharedPreferences: SharedPreferences // הוסר
    private val gson = Gson()
    private val activityScope = CoroutineScope(Dispatchers.Main + SupervisorJob())

    private lateinit var buttonAddApp: Button; private lateinit var buttonManageStoreApps: Button; private lateinit var switchNormalInstall: SwitchMaterial; private lateinit var textViewNormalInstallLabel: TextView; private lateinit var textViewRootSettingsLabel: TextView; private lateinit var switchUseRootInstall: SwitchMaterial; private lateinit var textViewRootInstallMethodLabel: TextView; private lateinit var radioGroupRootInstallMethod: RadioGroup; private lateinit var radioPmInstall: RadioButton; private lateinit var radioCopyToSystem: RadioButton; private lateinit var textViewCopyToSystemLocationLabel: TextView; private lateinit var radioGroupInstallLocation: RadioGroup; private lateinit var radioSystemApp: RadioButton; private lateinit var radioSystemPrivApp: RadioButton; private lateinit var switchUseCustomStorage: SwitchMaterial; private lateinit var editTextCustomStoragePath: EditText; private lateinit var switchEnableSendFeedback: SwitchMaterial; private lateinit var editTextAboutText: EditText; private lateinit var buttonExportStore: Button; private lateinit var buttonImportStore: Button; private lateinit var buttonLockStore: Button; private lateinit var editTextOldPassword: EditText; private lateinit var editTextNewPassword: EditText; private lateinit var editTextConfirmNewPassword: EditText; private lateinit var buttonChangePassword: Button; private lateinit var buttonSaveSettingsAndExit: Button

    private lateinit var pickApkLauncher: ActivityResultLauncher<Array<String>>
    private lateinit var pickImageLauncher: ActivityResultLauncher<Array<String>>
    private val manageAppsResultLauncher = registerForActivityResult(ActivityResultContracts.StartActivityForResult()) { result -> if (result.resultCode == Activity.RESULT_OK) setResult(Activity.RESULT_OK) }
    private val installPackageLauncher = registerForActivityResult(ActivityResultContracts.StartActivityForResult()) { result -> if (result.resultCode == Activity.RESULT_OK) Toast.makeText(this, getString(R.string.lock_store_update_started_toast), Toast.LENGTH_LONG).show() else Toast.makeText(this, getString(R.string.lock_store_update_failed_toast), Toast.LENGTH_LONG).show() }
    private val createDocumentLauncher = registerForActivityResult(ActivityResultContracts.CreateDocument("application/zip")) { uri: Uri? -> uri?.let { performExportStore(it) } }
    private val openDocumentLauncher = registerForActivityResult(ActivityResultContracts.OpenDocument()) { uri: Uri? -> uri?.let { showImportConfirmationDialog(it) } }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        // SharedPreferencesHelper.init(applicationContext) // נקרא מ-MainActivity.onCreate
        setContentView(R.layout.activity_settings)
        initializeViews()
        setupFilePickers()
        setupListeners()
        loadPreferences()
        updateUiStates()
    }

    private fun initializeViews() {
        buttonAddApp = findViewById(R.id.buttonAddApp); buttonManageStoreApps = findViewById(R.id.buttonManageStoreApps); switchNormalInstall = findViewById(R.id.switchNormalInstall); textViewNormalInstallLabel = findViewById(R.id.textViewNormalInstallLabel); textViewRootSettingsLabel = findViewById(R.id.textViewRootSettingsLabel); switchUseRootInstall = findViewById(R.id.switchUseRootInstall); textViewRootInstallMethodLabel = findViewById(R.id.textViewRootInstallMethodLabel); radioGroupRootInstallMethod = findViewById(R.id.radioGroupRootInstallMethod); radioPmInstall = findViewById(R.id.radioPmInstall); radioCopyToSystem = findViewById(R.id.radioCopyToSystem); textViewCopyToSystemLocationLabel = findViewById(R.id.textViewCopyToSystemLocationLabel); radioGroupInstallLocation = findViewById(R.id.radioGroupInstallLocation); radioSystemApp = findViewById(R.id.radioSystemApp); radioSystemPrivApp = findViewById(R.id.radioSystemPrivApp); switchUseCustomStorage = findViewById(R.id.switchUseCustomStorage); editTextCustomStoragePath = findViewById(R.id.editTextCustomStoragePath); switchEnableSendFeedback = findViewById(R.id.switchEnableSendFeedback); editTextAboutText = findViewById(R.id.editTextAboutText); buttonExportStore = findViewById(R.id.buttonExportStore); buttonImportStore = findViewById(R.id.buttonImportStore); buttonLockStore = findViewById(R.id.buttonLockStore); editTextOldPassword = findViewById(R.id.editTextOldPassword); editTextNewPassword = findViewById(R.id.editTextNewPassword); editTextConfirmNewPassword = findViewById(R.id.editTextConfirmNewPassword); buttonChangePassword = findViewById(R.id.buttonChangePassword); buttonSaveSettingsAndExit = findViewById(R.id.buttonSaveSettingsAndExit)
    }

    private fun setupFilePickers() {
        pickApkLauncher = registerForActivityResult(ActivityResultContracts.OpenDocument()) { uri: Uri? -> uri?.let { currentApkUri = it; Toast.makeText(this, "APK נבחר: ${getFileNameFromUri(it)}", Toast.LENGTH_SHORT).show() } }
        pickImageLauncher = registerForActivityResult(ActivityResultContracts.OpenDocument()) { uri: Uri? -> uri?.let { currentImageUri = it; Toast.makeText(this, "תמונה נבחרה: ${getFileNameFromUri(it)}", Toast.LENGTH_SHORT).show() } }
    }

    private fun setupListeners() {
        buttonAddApp.setOnClickListener { currentApkUri = null; currentImageUri = null; showAddAppDialog() }
        buttonManageStoreApps.setOnClickListener { manageAppsResultLauncher.launch(Intent(this, ManageStoreAppsActivity::class.java)) }
        switchNormalInstall.setOnCheckedChangeListener { _, isChecked -> if (isChecked && switchUseRootInstall.isChecked) switchUseRootInstall.isChecked = false; updateUiStates() }
        switchUseRootInstall.setOnCheckedChangeListener { _, isChecked -> if (isChecked && switchNormalInstall.isChecked) switchNormalInstall.isChecked = false; updateUiStates() }
        radioGroupRootInstallMethod.setOnCheckedChangeListener { _, _ -> updateUiStates() }
        switchUseCustomStorage.setOnCheckedChangeListener { _, isChecked -> editTextCustomStoragePath.isEnabled = isChecked; if (!isChecked) editTextCustomStoragePath.setText(""); updateUiStates() }
        buttonExportStore.setOnClickListener { val ts = System.currentTimeMillis(); createDocumentLauncher.launch("KosherAppStore_Backup_$ts.zip") }
        buttonImportStore.setOnClickListener { openDocumentLauncher.launch(arrayOf("application/zip")) }
        buttonLockStore.setOnClickListener { showLockStoreConfirmationDialog() }
        buttonChangePassword.setOnClickListener { changePassword() }
        buttonSaveSettingsAndExit.setOnClickListener { savePreferences(); setResult(Activity.RESULT_OK); finish() }
    }

    private fun updateUiStates() {
        val isNormalInstallChecked = switchNormalInstall.isChecked; val isUseRootInstallChecked = switchUseRootInstall.isChecked; val useCustomStorageChecked = switchUseCustomStorage.isChecked
        textViewRootSettingsLabel.isEnabled = !isNormalInstallChecked; switchUseRootInstall.isEnabled = !isNormalInstallChecked; editTextCustomStoragePath.isEnabled = useCustomStorageChecked
        val rootOptionsActive = !isNormalInstallChecked && isUseRootInstallChecked
        textViewRootInstallMethodLabel.isEnabled = rootOptionsActive; for (i in 0 until radioGroupRootInstallMethod.childCount) (radioGroupRootInstallMethod.getChildAt(i) as RadioButton).isEnabled = rootOptionsActive
        val copyToSystemMethodActive = rootOptionsActive && radioCopyToSystem.isChecked
        textViewCopyToSystemLocationLabel.isEnabled = copyToSystemMethodActive; for (i in 0 until radioGroupInstallLocation.childCount) (radioGroupInstallLocation.getChildAt(i) as RadioButton).isEnabled = copyToSystemMethodActive
    }

    private fun loadPreferences() {
        switchNormalInstall.isChecked = SharedPreferencesHelper.getBoolean(KEY_NORMAL_INSTALL_MODE, false); val normalISC = switchNormalInstall.isChecked; switchUseRootInstall.isChecked = if (normalISC) false else SharedPreferencesHelper.getBoolean(KEY_USE_ROOT_INSTALL, true)
        val rootM = SharedPreferencesHelper.getString(KEY_ROOT_INSTALL_METHOD, ROOT_METHOD_PM_INSTALL); if (rootM == ROOT_METHOD_COPY_TO_SYSTEM) radioCopyToSystem.isChecked = true else radioPmInstall.isChecked = true
        val loc = SharedPreferencesHelper.getString(KEY_INSTALL_LOCATION, "system/app"); if ("system/priv-app" == loc) radioSystemPrivApp.isChecked = true else radioSystemApp.isChecked = true
        switchUseCustomStorage.isChecked = SharedPreferencesHelper.getBoolean(KEY_USE_CUSTOM_STORAGE_PATH, false); editTextCustomStoragePath.setText(SharedPreferencesHelper.getString(KEY_CUSTOM_STORAGE_PATH, ""))
        switchEnableSendFeedback.isChecked = SharedPreferencesHelper.getBoolean(KEY_ENABLE_SEND_FEEDBACK, true); editTextAboutText.setText(SharedPreferencesHelper.getString(KEY_ABOUT_TEXT, DEFAULT_ABOUT_TEXT)); updateUiStates()
    }

    private fun savePreferences() {
        val useCustomPath = switchUseCustomStorage.isChecked; var customPathUserInput = editTextCustomStoragePath.text.toString().trim(); var pathForAppStorageInConfigFile = ""; var finalCustomPathToSaveInPrefsForEditText = customPathUserInput; var actualUseCustomPathSetting = useCustomPath
        if (useCustomPath) {
            if (customPathUserInput.isEmpty()) { pathForAppStorageInConfigFile = DEFAULT_SYSTEM_STORAGE_PATH_FOR_APPS; finalCustomPathToSaveInPrefsForEditText = "" }
            else { pathForAppStorageInConfigFile = if (customPathUserInput.startsWith("/system")) File(customPathUserInput, APPS_SUBDIR_NAME_IN_CONFIG_PATH).absolutePath else customPathUserInput }
            Log.d(TAG, "Custom path ON. Path for apps (to write in config): $pathForAppStorageInConfigFile. Path for Prefs EditText: $finalCustomPathToSaveInPrefsForEditText")
            activityScope.launch {
                val configDirEnsured = ensureSystemConfigDirAndFileExistsWithRoot()
                if (configDirEnsured) { if (pathForAppStorageInConfigFile.startsWith("/system")) { val appDirEnsured = ensureDirectoryExistsWithRoot(pathForAppStorageInConfigFile); if (!appDirEnsured) withContext(Dispatchers.Main) { Toast.makeText(this@SettingsActivity, "אזהרה: יצירת תיקיית אפליקציות ב-$pathForAppStorageInConfigFile נכשלה.", Toast.LENGTH_LONG).show() }}; val writeSuccess = writePathToSystemConfigFileWithRoot(pathForAppStorageInConfigFile); withContext(Dispatchers.Main) { if (writeSuccess) Toast.makeText(this@SettingsActivity, "נתיב אחסון עודכן בקובץ המערכת ל: $pathForAppStorageInConfigFile", Toast.LENGTH_SHORT).show() else { Toast.makeText(this@SettingsActivity, "אזהרה: כתיבת נתיב לקובץ המערכת נכשלה.", Toast.LENGTH_LONG).show(); switchUseCustomStorage.isChecked = false; actualUseCustomPathSetting = false; editTextCustomStoragePath.setText("") } } }
                else { withContext(Dispatchers.Main) { Toast.makeText(this@SettingsActivity, "שגיאה: לא ניתן ליצור קובץ קונפיגורציה במערכת.", Toast.LENGTH_LONG).show() }; actualUseCustomPathSetting = false; switchUseCustomStorage.isChecked = false; finalCustomPathToSaveInPrefsForEditText = "" }
                saveOtherPreferencesToHelper(actualUseCustomPathSetting, finalCustomPathToSaveInPrefsForEditText)
            }
        } else { activityScope.launch { if (ensureSystemConfigDirAndFileExistsWithRoot()) writePathToSystemConfigFileWithRoot("") else Log.e(TAG, "Could not ensure config file exists to clear it."); saveOtherPreferencesToHelper(false, "") }; finalCustomPathToSaveInPrefsForEditText = "" }
        if (!useCustomPath) { saveOtherPreferencesToHelper(false, ""); Toast.makeText(this, "הגדרות נשמרו", Toast.LENGTH_SHORT).show() }
        else { Toast.makeText(this, "שומר הגדרות (פעולות רוט ברקע)...", Toast.LENGTH_SHORT).show() }
        setResult(Activity.RESULT_OK)
    }

    private fun saveOtherPreferencesToHelper(useCustomPath: Boolean, customPathForEditText: String) {
        SharedPreferencesHelper.edit {
            putBoolean(KEY_NORMAL_INSTALL_MODE, switchNormalInstall.isChecked); putBoolean(KEY_USE_ROOT_INSTALL, switchUseRootInstall.isChecked); val rM = if (radioCopyToSystem.isChecked) ROOT_METHOD_COPY_TO_SYSTEM else ROOT_METHOD_PM_INSTALL; putString(KEY_ROOT_INSTALL_METHOD, rM); val iL = if (radioSystemPrivApp.isChecked) "system/priv-app" else "system/app"; putString(KEY_INSTALL_LOCATION, iL);
            putBoolean(KEY_USE_CUSTOM_STORAGE_PATH, useCustomPath); putString(KEY_CUSTOM_STORAGE_PATH, customPathForEditText);
            putBoolean(KEY_ENABLE_SEND_FEEDBACK, switchEnableSendFeedback.isChecked); putString(KEY_ABOUT_TEXT, editTextAboutText.text.toString())
        }
    }

    private fun getTargetFilesDirForAppContent(): File { return MainActivity.getActiveStoreFilesBasePath(applicationContext) }

    private fun showAddAppDialog() {
        val builder = AlertDialog.Builder(this); val inflater = this.layoutInflater; val dialogView = inflater.inflate(R.layout.dialog_add_app, null); builder.setView(dialogView)
        editTextDialogAppName = dialogView.findViewById(R.id.editTextNewAppName); editTextDialogAppDescription = dialogView.findViewById(R.id.editTextNewAppDescription); editTextDialogAppPackageName = dialogView.findViewById(R.id.editTextNewAppPackageName)
        val btnSelectApk: Button = dialogView.findViewById(R.id.buttonSelectApk); val btnSelectImg: Button = dialogView.findViewById(R.id.buttonSelectImage)
        currentApkUri = null; currentImageUri = null
        btnSelectApk.setOnClickListener { pickApkLauncher.launch(arrayOf("application/vnd.android.package-archive")) }
        btnSelectImg.setOnClickListener { pickImageLauncher.launch(arrayOf("image/*")) }
        builder.setTitle(getString(R.string.add_app_dialog_title))
        builder.setPositiveButton(getString(R.string.add_button_text)) { dialog, _ ->
            val appName = editTextDialogAppName?.text.toString().trim(); val appDesc = editTextDialogAppDescription?.text.toString().trim(); val appPkg = editTextDialogAppPackageName?.text.toString().trim()
            val apkToSaveUri = currentApkUri
            if (TextUtils.isEmpty(appName) || TextUtils.isEmpty(appDesc) || TextUtils.isEmpty(appPkg) || apkToSaveUri == null) { Toast.makeText(this, getString(R.string.fill_all_fields_apk_toast), Toast.LENGTH_LONG).show(); return@setPositiveButton }
            activityScope.launch {
                val originalApkFileName = getFileNameFromUri(apkToSaveUri); val savedApkFileName = saveFileToActiveStorage(apkToSaveUri, originalApkFileName)
                var savedImageFileName: String? = null
                currentImageUri?.let { imgUri -> val origImgName = getFileNameFromUri(imgUri); savedImageFileName = saveFileToActiveStorage(imgUri, origImgName) }
                withContext(Dispatchers.Main) {
                    if (savedApkFileName != null) { val newApp = AppInfo(appName, appDesc, savedApkFileName, savedImageFileName, appPkg); val storedApps = loadAppsListFromPrefs().toMutableList(); storedApps.add(newApp); saveAppsListDirectlyToPrefs(storedApps); Toast.makeText(this@SettingsActivity, getString(R.string.app_added_toast, appName), Toast.LENGTH_SHORT).show(); setResult(Activity.RESULT_OK) }
                    else { Toast.makeText(this@SettingsActivity, getString(R.string.critical_error_saving_apk_toast), Toast.LENGTH_LONG).show() }
                    dialog.dismiss()
                }
            }
        }
        builder.setNegativeButton(getString(R.string.cancel_button_text)) { dialog, _ -> dialog.cancel() }; builder.show()
    }

    private fun saveAppsListDirectlyToPrefs(updatedAppList: List<AppInfo>) { SharedPreferencesHelper.edit { putString(KEY_APPS_LIST, gson.toJson(updatedAppList)) } }
    private fun loadAppsListFromPrefs(): List<AppInfo> { val json = SharedPreferencesHelper.getString(KEY_APPS_LIST, null); return if (json != null) { val type: Type = object:TypeToken<ArrayList<AppInfo>>(){}.type; try { gson.fromJson(json, type) ?: ArrayList() } catch(e:Exception){ Log.e(TAG, "Parse error loading app list", e); ArrayList()}} else ArrayList() }
    private fun getFileNameFromUri(uri: Uri): String { var fn: String? = null; if(uri.scheme == "content"){ try { contentResolver.query(uri,null,null,null,null)?.use { c -> if(c.moveToFirst()){ val i = c.getColumnIndex(OpenableColumns.DISPLAY_NAME); if(i!=-1) fn=c.getString(i) else Log.w(TAG, "DISPLAY_NAME column not found in URI.") }}}catch(e:Exception){Log.e(TAG,"FN URI err: ${e.message}",e)}}; if(fn==null) fn=uri.path?.substringAfterLast('/'); return "${UUID.randomUUID().toString().substring(0,8)}_${fn ?: "unknown_file.tmp"}" }

    private suspend fun saveFileToActiveStorage(sourceUri: Uri, desiredFileNameInTargetDir: String): String? = withContext(Dispatchers.IO) {
        val targetDir = MainActivity.getActiveStoreFilesBasePath(applicationContext); val destinationFile = File(targetDir, desiredFileNameInTargetDir); Log.d(TAG, "Attempting to save to: ${destinationFile.absolutePath}")
        if (!targetDir.exists()) { val created = if (targetDir.absolutePath.startsWith("/system")) ensureDirectoryExistsWithRoot(targetDir.absolutePath) else targetDir.mkdirs(); if (!created && !targetDir.exists()) { Log.e(TAG, "Failed to create target directory: ${targetDir.absolutePath}"); withContext(Dispatchers.Main){Toast.makeText(this@SettingsActivity, "Error creating target dir: ${targetDir.path}", Toast.LENGTH_LONG).show()}; return@withContext null } }
        try {
            if (targetDir.absolutePath.startsWith("/system")) {
                val tempFile = File(cacheDir, "temp_copy_${UUID.randomUUID()}_${desiredFileNameInTargetDir.replace("/", "_")}"); applicationContext.contentResolver.openInputStream(sourceUri)?.use { i -> FileOutputStream(tempFile).use { o -> i.copyTo(o) } } ?: return@withContext null
                val rootCopyOk = executeCopyFileWithRoot(tempFile.absolutePath, destinationFile.absolutePath); tempFile.delete()
                return@withContext if (rootCopyOk) destinationFile.name else null
            } else { applicationContext.contentResolver.openInputStream(sourceUri)?.use { iS -> FileOutputStream(destinationFile).use { oS -> iS.copyTo(oS) } }; return@withContext destinationFile.name }
        } catch (e: Exception) { Log.e(TAG, "Error saveFileToActiveStorage for ${destinationFile.absolutePath}", e); withContext(Dispatchers.Main){Toast.makeText(this@SettingsActivity, "Error saving file: ${e.message}", Toast.LENGTH_LONG).show()}; return@withContext null }
    }

    private fun changePassword() { val oP=editTextOldPassword.text.toString(); val nP=editTextNewPassword.text.toString(); val cNP=editTextConfirmNewPassword.text.toString(); val sP=SharedPreferencesHelper.getString(KEY_SETTINGS_PASSWORD, DEFAULT_PASSWORD); if(TextUtils.isEmpty(oP)||TextUtils.isEmpty(nP)||TextUtils.isEmpty(cNP)){Toast.makeText(this,"מלא כל השדות",Toast.LENGTH_SHORT).show();return}; if(oP!=sP){Toast.makeText(this,"סיסמה נוכחית שגויה",Toast.LENGTH_SHORT).show();return}; if(nP!=cNP){Toast.makeText(this,"סיסמאות לא תואמות",Toast.LENGTH_SHORT).show();return}; if(nP.length<6){Toast.makeText(this,"סיסמה לפחות 6 תווים",Toast.LENGTH_SHORT).show();return}; SharedPreferencesHelper.edit{putString(KEY_SETTINGS_PASSWORD,nP)}; Toast.makeText(this,"סיסמה שונתה",Toast.LENGTH_SHORT).show(); editTextOldPassword.setText(""); editTextNewPassword.setText(""); editTextConfirmNewPassword.setText("") }
    private fun showLockStoreConfirmationDialog() { AlertDialog.Builder(this).setTitle(getString(R.string.lock_store_warning_title)).setMessage(getString(R.string.lock_store_warning_message)).setIcon(android.R.drawable.ic_dialog_alert).setPositiveButton(getString(R.string.lock_store_confirm_button)) { _, _ -> initiateLockStoreProcess() }.setNegativeButton(getString(R.string.cancel_button_text), null).show() }
    private fun initiateLockStoreProcess() { val dF = File(cacheDir, LOCKED_APK_ASSET_NAME); try { assets.open(LOCKED_APK_ASSET_NAME).use { iS -> FileOutputStream(dF).use { oS -> iS.copyTo(oS) } }; Log.d(TAG, "Locked APK copied to: ${dF.absolutePath}"); if (dF.exists()) { val apkU = FileProvider.getUriForFile(this, "${applicationContext.packageName}.provider", dF); val iI = Intent(Intent.ACTION_VIEW).apply { setDataAndType(apkU, "application/vnd.android.package-archive"); addFlags(Intent.FLAG_ACTIVITY_NEW_TASK); addFlags(Intent.FLAG_GRANT_READ_URI_PERMISSION) }; try { installPackageLauncher.launch(iI) } catch (e: Exception) { Toast.makeText(this, "שגיאה בהתקנת נעולה: ${e.message}", Toast.LENGTH_LONG).show(); dF.delete() } } else { Toast.makeText(this, getString(R.string.lock_store_apk_not_found_toast), Toast.LENGTH_LONG).show() } } catch (e: IOException) { Toast.makeText(this, getString(R.string.lock_store_asset_error_toast, LOCKED_APK_ASSET_NAME)+"\nError: ${e.localizedMessage}", Toast.LENGTH_LONG).show(); dF.delete() } }
    private fun performExportStore(uri: Uri) { Toast.makeText(this,getString(R.string.export_starting_toast),Toast.LENGTH_SHORT).show();val bDir=getTargetFilesDirForAppContent();activityScope.launch(Dispatchers.IO){var s=false;try{contentResolver.openOutputStream(uri)?.use{oS->ZipOutputStream(BufferedOutputStream(oS)).use{zos->val list=loadAppsListFromPrefs();val cfg=StoreConfig(list,SharedPreferencesHelper.getString(KEY_SETTINGS_PASSWORD,DEFAULT_PASSWORD),SharedPreferencesHelper.getBoolean(KEY_NORMAL_INSTALL_MODE,false),SharedPreferencesHelper.getBoolean(KEY_USE_ROOT_INSTALL,true),SharedPreferencesHelper.getString(KEY_ROOT_INSTALL_METHOD,ROOT_METHOD_PM_INSTALL),SharedPreferencesHelper.getString(KEY_INSTALL_LOCATION,"system/app"),SharedPreferencesHelper.getBoolean(KEY_ENABLE_SEND_FEEDBACK,true),SharedPreferencesHelper.getString(KEY_ABOUT_TEXT,DEFAULT_ABOUT_TEXT),SharedPreferencesHelper.getBoolean(KEY_USE_CUSTOM_STORAGE_PATH,false),SharedPreferencesHelper.getString(KEY_CUSTOM_STORAGE_PATH,""));val json=gson.toJson(cfg);zos.putNextEntry(ZipEntry(MANIFEST_FILE_NAME));zos.write(json.toByteArray());zos.closeEntry();list.forEach{app->if(app.apkFileName.isNotEmpty()){val f=File(bDir,app.apkFileName);if(f.exists())addFileToZip(f,"$APKS_DIR_NAME/${app.apkFileName}",zos)};app.imageFileName?.let{if(it.isNotEmpty()){val f=File(bDir,it);if(f.exists())addFileToZip(f,"$IMAGES_DIR_NAME/$it",zos)}}}}};s=true}catch(e:Exception){Log.e(TAG,"Export err",e);withContext(Dispatchers.Main){Toast.makeText(this@SettingsActivity,getString(R.string.export_error_toast,e.message),Toast.LENGTH_LONG).show()}};withContext(Dispatchers.Main){if(s)Toast.makeText(this@SettingsActivity,getString(R.string.export_success_toast),Toast.LENGTH_LONG).show()}}}
    private fun addFileToZip(file: File, entryName: String, zos: ZipOutputStream) { FileInputStream(file).use { fis -> BufferedInputStream(fis).use { bis -> val entry = ZipEntry(entryName); zos.putNextEntry(entry); bis.copyTo(zos); zos.closeEntry(); Log.d(TAG, "ZIP Added: $entryName") } } }
    private fun showImportConfirmationDialog(uri: Uri){ AlertDialog.Builder(this).setTitle(getString(R.string.import_confirmation_title)).setMessage(getString(R.string.import_confirmation_message)).setPositiveButton(getString(R.string.import_confirm_button)) { _, _ -> performImportStore(uri) }.setNegativeButton(getString(R.string.cancel_button_text), null).show() }
    private fun performImportStore(uri: Uri) {
        Toast.makeText(this, getString(R.string.import_starting_toast), Toast.LENGTH_SHORT).show()
        val targetDirForImportedFiles = getTargetFilesDirForAppContent() // הנתיב הסופי לאפליקציות/תמונות

        activityScope.launch { // כבר רץ על Dispatchers.Main, פעולות IO ילכו ל-Dispatchers.IO בפנים
            var importSuccess = false
            var manifestConfigFromFile: StoreConfig? = null
            val importedApkFilesMap = mutableMapOf<String, File>() // שם קובץ ב-ZIP -> קובץ זמני על הדיסק
            val importedImageFilesMap = mutableMapOf<String, File>()
            val tempExtractionDir = File(cacheDir, "import_temp_${System.currentTimeMillis()}")

            try {
                if (!tempExtractionDir.exists()) {
                    tempExtractionDir.mkdirs()
                }

                withContext(Dispatchers.IO) { // פעולות קריאה וכתיבה של קבצים
                    applicationContext.contentResolver.openInputStream(uri)?.use { inputStream ->
                        ZipInputStream(BufferedInputStream(inputStream)).use { zis ->
                            var entry: ZipEntry? = zis.nextEntry
                            while (entry != null) {
                                val currentEntry = entry // לשימוש בטוח בתוך ה-scope
                                Log.d(TAG, "Processing ZIP entry: ${currentEntry.name}")
                                if (!currentEntry.isDirectory) {
                                    val originalEntryName = currentEntry.name // למשל, apks/myapp.apk או images/icon.png
                                    val fileNameInZip = originalEntryName.substringAfterLast('/')

                                    if (fileNameInZip.isNotEmpty()) {
                                        val tempFile = File(tempExtractionDir, fileNameInZip)
                                        FileOutputStream(tempFile).use { fos -> zis.copyTo(fos) }
                                        Log.d(TAG, "Extracted to temp: ${tempFile.absolutePath} from ZIP entry: ${currentEntry.name}")

                                        when {
                                            currentEntry.name == MANIFEST_FILE_NAME -> {
                                                manifestConfigFromFile = gson.fromJson(tempFile.readText(), StoreConfig::class.java)
                                                tempFile.delete()
                                            }
                                            currentEntry.name.startsWith("$APKS_DIR_NAME/") -> {
                                                val apkKey = currentEntry.name.substringAfter("$APKS_DIR_NAME/")
                                                if (apkKey.isNotEmpty()) importedApkFilesMap[apkKey] = tempFile
                                                else tempFile.delete()
                                            }
                                            currentEntry.name.startsWith("$IMAGES_DIR_NAME/") -> {
                                                val imageKey = currentEntry.name.substringAfter("$IMAGES_DIR_NAME/")
                                                if (imageKey.isNotEmpty()) importedImageFilesMap[imageKey] = tempFile
                                                else tempFile.delete()
                                            }
                                            else -> {
                                                Log.w(TAG, "Unknown file in ZIP root, deleting: ${currentEntry.name}")
                                                tempFile.delete()
                                            }
                                        }
                                    } else {
                                        Log.w(TAG, "ZIP entry with empty filename after slash: ${currentEntry.name}")
                                    }
                                }
                                zis.closeEntry()
                                entry = zis.nextEntry
                            }
                        }
                    } ?: run {
                        Log.e(TAG, "Failed to open input stream from import URI.")
                        throw IOException("Cannot open import file stream") // זרוק שגיאה כדי להגיע ל-catch
                    }
                } // סוף withContext(Dispatchers.IO)

                val configToImport = manifestConfigFromFile ?: run {
                    withContext(Dispatchers.Main) { Toast.makeText(this@SettingsActivity, getString(R.string.import_manifest_error_toast), Toast.LENGTH_LONG).show() }
                    return@launch // צא מהקורוטינה אם המניפסט לא תקין
                }

                // מחיקת אפליקציות וקבצים ישנים מהמיקום *הנוכחי* הפעיל
                val oldApps = loadAppsListFromPrefs() // קורא מה-SharedPreferencesHelper
                val currentActiveAppDirForOldFiles = MainActivity.getActiveStoreFilesBasePath(applicationContext) // הנתיב הנוכחי
                withContext(Dispatchers.IO) {
                    oldApps.forEach { oldApp ->
                        File(currentActiveAppDirForOldFiles, oldApp.apkFileName).delete()
                        oldApp.imageFileName?.let { File(currentActiveAppDirForOldFiles, it).delete() }
                    }
                }

                // שמור את הגדרות הנתיב החדשות *לפני* העברת הקבצים, כדי ש-getTargetFilesDirForAppContent יחזיר את הנתיב הנכון
                SharedPreferencesHelper.edit {
                    putBoolean(KEY_USE_CUSTOM_STORAGE_PATH, configToImport.useCustomStoragePath)
                    putString(KEY_CUSTOM_STORAGE_PATH, configToImport.customStoragePath ?: "")
                    // כאן גם צריך לוודא שתיקיית הקונפיגורציה בסיסטם מעודכנת עם הנתיב החדש לאפליקציות
                    // אם configToImport.useCustomStoragePath הוא true
                }
                // אם הנתיב החדש הוא בסיסטם, ודא שהתיקיות נוצרו
                val newTargetDirForImportedFiles = MainActivity.getActiveStoreFilesBasePath(applicationContext) // קבל את הנתיב המעודכן
                if (newTargetDirForImportedFiles.absolutePath.startsWith("/system")) {
                    if (!withContext(Dispatchers.IO) { ensureDirectoryExistsWithRoot(newTargetDirForImportedFiles.absolutePath) }) {
                        throw IOException("Failed to create new system target directory for import: ${newTargetDirForImportedFiles.absolutePath}")
                    }
                } else {
                    if (!newTargetDirForImportedFiles.exists()) newTargetDirForImportedFiles.mkdirs()
                }


                val newAppList = configToImport.appList.mapNotNull { appInfoFromManifest ->
                    var finalApkNameInStorage: String? = appInfoFromManifest.apkFileName
                    var finalImageNameInStorage: String? = appInfoFromManifest.imageFileName

                    // העבר APK אם קיים ב-ZIP למיקום החדש
                    val tempApkFile = importedApkFilesMap[appInfoFromManifest.apkFileName]
                    if (tempApkFile != null && tempApkFile.exists()) {
                        val destApkFile = File(newTargetDirForImportedFiles, appInfoFromManifest.apkFileName)
                        val moved = withContext(Dispatchers.IO) { tempApkFile.renameTo(destApkFile) }
                        if (moved) {
                            Log.d(TAG, "Moved imported APK: ${destApkFile.name} to ${newTargetDirForImportedFiles.absolutePath}")
                        } else {
                            Log.e(TAG, "Failed to move APK: ${tempApkFile.name} to ${destApkFile.name}. Source exists: ${tempApkFile.exists()}")
                            finalApkNameInStorage = null
                        }
                    } else if (appInfoFromManifest.apkUrl.isNullOrEmpty() && !appInfoFromManifest.apkFileName.isNullOrEmpty()) {
                        // אם אין URL והקובץ לא נמצא ב-ZIP, סמן כחסר
                        Log.w(TAG, "APK file ${appInfoFromManifest.apkFileName} not found in ZIP and no URL for app ${appInfoFromManifest.name}")
                        finalApkNameInStorage = null
                    }


                    // העבר תמונה אם קיימת ב-ZIP למיקום החדש
                    appInfoFromManifest.imageFileName?.let { manifestImageName ->
                        val tempImageFile = importedImageFilesMap[manifestImageName]
                        if (tempImageFile != null && tempImageFile.exists()) {
                            val destImageFile = File(newTargetDirForImportedFiles, manifestImageName)
                            val moved = withContext(Dispatchers.IO) { tempImageFile.renameTo(destImageFile) }
                            if (moved) {
                                Log.d(TAG, "Moved imported Image: ${destImageFile.name} to ${newTargetDirForImportedFiles.absolutePath}")
                            } else {
                                Log.e(TAG, "Failed to move Image: ${tempImageFile.name} to ${destImageFile.name}. Source exists: ${tempImageFile.exists()}")
                                finalImageNameInStorage = null
                            }
                        } else {
                            Log.w(TAG, "Image file $manifestImageName not found in ZIP for app ${appInfoFromManifest.name}")
                            finalImageNameInStorage = null
                        }
                    }

                    if (!finalApkNameInStorage.isNullOrEmpty() || !appInfoFromManifest.apkUrl.isNullOrEmpty()) {
                        appInfoFromManifest.copy(
                            apkFileName = finalApkNameInStorage ?: appInfoFromManifest.apkFileName,
                            imageFileName = finalImageNameInStorage
                        )
                    } else {
                        Log.w(TAG, "Skipping app ${appInfoFromManifest.name} from import: No valid APK source.")
                        null
                    }
                }

                saveAppsListDirectlyToPrefs(newAppList)

                SharedPreferencesHelper.edit {
                    putString(KEY_SETTINGS_PASSWORD, configToImport.settingsPassword ?: DEFAULT_PASSWORD)
                    putBoolean(KEY_NORMAL_INSTALL_MODE, configToImport.normalInstallMode)
                    putBoolean(KEY_USE_ROOT_INSTALL, configToImport.useRootInstall)
                    putString(KEY_ROOT_INSTALL_METHOD, configToImport.rootInstallMethod ?: ROOT_METHOD_PM_INSTALL)
                    putString(KEY_INSTALL_LOCATION, configToImport.installLocation ?: "system/app")
                    putBoolean(KEY_ENABLE_SEND_FEEDBACK, configToImport.enableSendFeedback)
                    putString(KEY_ABOUT_TEXT, configToImport.aboutText ?: DEFAULT_ABOUT_TEXT)
                    // הגדרות הנתיב כבר עודכנו למעלה כדי ש-newTargetDirForImportedFiles יהיה נכון
                    // כאן רק נוודא שהן נשמרות אם המניפסט דורס אותן
                    putBoolean(KEY_USE_CUSTOM_STORAGE_PATH, configToImport.useCustomStoragePath)
                    putString(KEY_CUSTOM_STORAGE_PATH, configToImport.customStoragePath ?: "")
                }
                importSuccess = true
            } catch (e: Exception) {
                Log.e(TAG, "Error during import processing", e)
                withContext(Dispatchers.Main) {
                    Toast.makeText(this@SettingsActivity, getString(R.string.import_error_toast, e.message), Toast.LENGTH_LONG).show()
                }
            } finally {
                withContext(Dispatchers.IO) { tempExtractionDir.deleteRecursively() }
                Log.d(TAG, "Temp import directory ${tempExtractionDir.name} deleted.")
            }

            withContext(Dispatchers.Main) {
                if (importSuccess) {
                    Toast.makeText(this@SettingsActivity, getString(R.string.import_success_toast), Toast.LENGTH_LONG).show()
                    loadPreferences()
                    updateUiStates()
                    setResult(Activity.RESULT_OK)
                }
            }
        }
    }

private suspend fun ensureSystemConfigDirAndFileExistsWithRoot(): Boolean = withContext(Dispatchers.IO) {
    val configDir = File(KOSHER_STORE_BASE_DIR_SYSTEM); val configFile = File(configDir, CONFIG_FILE_NAME)
    var dirOK = if (configDir.exists() && configDir.isDirectory) true else executeShellCommandsWithRoot(listOf("mkdir -p '${configDir.absolutePath}'", "chmod 755 '${configDir.absolutePath}'", "chown system:system '${configDir.absolutePath}'"))
    if (!dirOK) { Log.e(TAG, "Failed to ensure config directory: ${configDir.absolutePath}"); return@withContext false }
    if (!configFile.exists()) {
        Log.d(TAG, "Config file ${configFile.absolutePath} does not exist. Creating.")
        val currentCustomPathFromPrefs = SharedPreferencesHelper.getString(KEY_CUSTOM_STORAGE_PATH, "")?.trim()
        val defaultPathForAppsInConfig = if (currentCustomPathFromPrefs.isNullOrEmpty()) DEFAULT_SYSTEM_STORAGE_PATH_FOR_APPS else { if (currentCustomPathFromPrefs.startsWith("/system")) File(currentCustomPathFromPrefs, APPS_SUBDIR_NAME_IN_CONFIG_PATH).absolutePath else currentCustomPathFromPrefs }
        val escapedDefaultPath = defaultPathForAppsInConfig.replace("'", "'\\''")
        return@withContext executeShellCommandsWithRoot(listOf("echo '$escapedDefaultPath' > '${configFile.absolutePath}'", "chmod 644 '${configFile.absolutePath}'", "chown system:system '${configFile.absolutePath}'"))
    }
    return@withContext true
}
private suspend fun writePathToSystemConfigFileWithRoot(pathToWrite: String): Boolean = withContext(Dispatchers.IO) {
    val configFilePath = "$KOSHER_STORE_BASE_DIR_SYSTEM/$CONFIG_FILE_NAME"; val escapedPath = pathToWrite.replace("'", "'\\''")
    return@withContext executeShellCommandsWithRoot(listOf("echo '$escapedPath' > '$configFilePath'", "chmod 644 '$configFilePath'"))
}
private suspend fun ensureDirectoryExistsWithRoot(dirPath: String): Boolean = withContext(Dispatchers.IO) {
    val targetFile = File(dirPath); if (targetFile.exists() && targetFile.isDirectory) return@withContext true; if (targetFile.exists() && !targetFile.isDirectory) { Log.e(TAG, "Path exists but not a dir: $dirPath"); return@withContext false }
    return@withContext executeShellCommandsWithRoot(listOf("mkdir -p '$dirPath'", "chmod 777 '$dirPath'"))
}
private suspend fun executeCopyFileWithRoot(sourcePath: String, destPath: String): Boolean = withContext(Dispatchers.IO) {
    return@withContext executeShellCommandsWithRoot(listOf("cp -f '$sourcePath' '$destPath'", "chmod 644 '$destPath'"))
}
private suspend fun executeShellCommandsWithRoot(commands: List<String>): Boolean = withContext(Dispatchers.IO) {
    var success = false
    try {
        val su = Runtime.getRuntime().exec("su"); DataOutputStream(su.outputStream).use { os ->
            val needsMount = commands.any { cmd -> cmd.contains("'/system/") || cmd.contains(" /system/") || cmd.contains("mkdir -p '/system") || cmd.contains("touch '/system") || cmd.contains("echo .* > '/system") }
            if(needsMount) os.writeBytes("mount -o rw,remount /system\n")
            commands.forEach { cmd -> os.writeBytes("$cmd\n"); Log.d(TAG,"ROOT_CMD: $cmd") }
            if(needsMount) os.writeBytes("mount -o ro,remount /system\n")
            os.writeBytes("exit\n"); os.flush()
        }
        val exitCode = su.waitFor()
        if (exitCode == 0) success = true else { val err = su.errorStream.bufferedReader().readText(); Log.e(TAG, "Root cmd fail. Exit: $exitCode. Err: $err")}
        su.destroy()
    } catch (e: Exception) { Log.e(TAG, "Root cmd exception", e) }
    return@withContext success
}
}