package com.yossi.kosherappstore

import android.content.Context
import android.graphics.BitmapFactory
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageButton
import android.widget.ImageView
import android.widget.TextView
import androidx.recyclerview.widget.RecyclerView
import java.io.File

class ManageAppsAdapter(
    private val context: Context,
    var appList: MutableList<AppInfo>, // שים לב ל-var כדי שנוכל לשנות אותו מבחוץ אם צריך, או ש-removeItem יעבוד על עותק
    private val onDeleteButtonClickListener: (AppInfo, Int) -> Unit
) : RecyclerView.Adapter<ManageAppsAdapter.ManageAppViewHolder>() {

    inner class ManageAppViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        val appIcon: ImageView = itemView.findViewById(R.id.imageViewAppIconManage)
        val appName: TextView = itemView.findViewById(R.id.textViewAppNameManage)
        val appPackageName: TextView = itemView.findViewById(R.id.textViewAppPackageNameManage)
        val deleteButton: ImageButton = itemView.findViewById(R.id.buttonDeleteFromStoreManage)
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ManageAppViewHolder {
        val view = LayoutInflater.from(context).inflate(R.layout.list_item_manage_app, parent, false)
        return ManageAppViewHolder(view)
    }

    override fun onBindViewHolder(holder: ManageAppViewHolder, position: Int) {
        val appInfo = appList[position]
        holder.appName.text = appInfo.name
        holder.appPackageName.text = appInfo.packageName

        appInfo.imageFileName?.let { fileName ->
            if (fileName.isNotEmpty()) {
                val imgFile = File(context.filesDir, fileName)
                if (imgFile.exists()) {
                    holder.appIcon.setImageBitmap(BitmapFactory.decodeFile(imgFile.absolutePath))
                } else {
                    holder.appIcon.setImageResource(R.mipmap.ic_launcher)
                }
            } else {
                holder.appIcon.setImageResource(R.mipmap.ic_launcher)
            }
        } ?: holder.appIcon.setImageResource(R.mipmap.ic_launcher)

        holder.deleteButton.setOnClickListener {
            onDeleteButtonClickListener(appInfo, holder.adapterPosition)
        }
    }

    override fun getItemCount(): Int = appList.size

    fun removeItem(position: Int) {
        if (position >= 0 && position < appList.size) {
            appList.removeAt(position)
            notifyItemRemoved(position)
            // נדרש לעדכן מיקומים של פריטים שנותרו אחרי המחיקה
            if (position < appList.size) { // אם לא מחקנו את האחרון
                notifyItemRangeChanged(position, appList.size - position)
            }
        }
    }

    // אם רוצים לרענן את כל הרשימה מבחוץ
    fun updateData(newAppList: List<AppInfo>) {
        appList.clear()
        appList.addAll(newAppList)
        notifyDataSetChanged()
    }
}