package com.yossi.kosherappstore

import android.content.Context
import android.os.Build
import android.os.Bundle
import android.text.Html
import android.text.method.LinkMovementMethod
import android.view.MenuItem
import android.widget.TextView
import androidx.appcompat.app.AppCompatActivity

class AboutActivity : AppCompatActivity() {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_about)

        supportActionBar?.setDisplayHomeAsUpEnabled(true) // הוספת כפתור חזור
        title = getString(R.string.about_activity_title) // שימוש במחרוזת מה-strings.xml

        val textViewAboutContent: TextView = findViewById(R.id.textViewAboutContent)

        val sharedPreferences = getSharedPreferences(MainActivity.PREFS_NAME, Context.MODE_PRIVATE)
        val aboutTextHtml = sharedPreferences.getString(
            MainActivity.KEY_ABOUT_TEXT,
            getString(R.string.default_about_text) // שימוש במחרוזת ברירת מחדל מה-strings.xml
        ) ?: getString(R.string.default_about_text)

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
            textViewAboutContent.text = Html.fromHtml(aboutTextHtml, Html.FROM_HTML_MODE_COMPACT)
        } else {
            @Suppress("DEPRECATION")
            textViewAboutContent.text = Html.fromHtml(aboutTextHtml)
        }
        textViewAboutContent.movementMethod = LinkMovementMethod.getInstance()
    }

    override fun onOptionsItemSelected(item: MenuItem): Boolean {
        if (item.itemId == android.R.id.home) {
            onBackPressedDispatcher.onBackPressed()
            return true
        }
        return super.onOptionsItemSelected(item)
    }
}